/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

public class Platform {
    private static final Platform myself = new Platform();
    private String platform;
    private boolean windows;
    private boolean posix = true;

    private Platform() {
        String OS2 = System.getProperty("os.name").toLowerCase();
        if (OS2.contains("mac")) {
            this.platform = "darwin";
        } else if (OS2.contains("freebsd")) {
            this.platform = "freebsd";
        } else if (OS2.contains("linux")) {
            this.platform = "linux";
        } else if (OS2.contains("sunos")) {
            this.platform = "sunos";
        } else if (OS2.contains("win")) {
            this.platform = "win32";
            this.windows = true;
            this.posix = false;
        } else {
            this.platform = "?";
        }
    }

    public static Platform get() {
        return myself;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public boolean isPosixFilesystem() {
        return this.posix;
    }
}

