/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal.handles;

import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.internal.handles.AbstractHandle;
import io.apigee.trireme.core.internal.handles.HandleListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;

public class JavaInputStreamHandle
extends AbstractHandle {
    private static final int READ_BUFFER_SIZE = 16392;
    private final InputStream in;
    private final NodeRuntime runtime;
    private Future<?> readTask;
    private volatile boolean reading;

    public JavaInputStreamHandle(InputStream in, NodeRuntime runtime) {
        this.in = in;
        this.runtime = runtime;
    }

    public void startReading(final HandleListener listener, final Object context) {
        if (this.reading) {
            return;
        }
        this.reading = true;
        this.runtime.pin();
        this.readTask = this.runtime.getUnboundedPool().submit(new Runnable(){

            public void run() {
                JavaInputStreamHandle.this.readLoop(listener, context);
            }
        });
    }

    protected void readLoop(HandleListener listener, Object context) {
        byte[] readBuf = new byte[16392];
        try {
            int count = 0;
            while (this.reading && count >= 0) {
                count = this.in.read(readBuf);
                if (count <= 0) continue;
                ByteBuffer buf = ByteBuffer.allocate(count);
                buf.put(readBuf, 0, count);
                buf.flip();
                listener.onReadComplete(buf, false, context);
            }
            if (count < 0) {
                listener.onReadError("EOF", false, context);
            }
        }
        catch (InterruptedIOException iee) {
        }
        catch (EOFException eofe) {
            listener.onReadError("EOF", false, context);
        }
        catch (IOException ioe) {
            String err = "Stream Closed".equalsIgnoreCase(ioe.getMessage()) ? "EOF" : "EIO";
            listener.onReadError(err, false, context);
        }
    }

    public void stopReading() {
        if (this.reading) {
            this.runtime.unPin();
            this.reading = false;
        }
        if (this.readTask != null) {
            this.readTask.cancel(true);
        }
    }

    public void close() {
        this.stopReading();
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

