/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.internal.CryptoAlgorithms;
import io.apigee.trireme.core.internal.CryptoService;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.crypto.CipherImpl;
import io.apigee.trireme.core.modules.crypto.DHGroupImpl;
import io.apigee.trireme.core.modules.crypto.DHImpl;
import io.apigee.trireme.core.modules.crypto.DecipherImpl;
import io.apigee.trireme.core.modules.crypto.HashImpl;
import io.apigee.trireme.core.modules.crypto.MacImpl;
import io.apigee.trireme.core.modules.crypto.SignImpl;
import io.apigee.trireme.core.modules.crypto.VerifyImpl;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.ServiceLoader;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crypto
implements InternalNodeModule {
    private static final Logger log = LoggerFactory.getLogger(Crypto.class);
    public static final String MODULE_NAME = "crypto";
    public static final long MAX_BUFFER_LEN = 0x3FFFFFFFL;
    protected static CryptoService cryptoService;
    protected static Provider cryptoProvider;

    public String getModuleName() {
        return MODULE_NAME;
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runtime) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, CryptoImpl.class);
        CryptoImpl export = (CryptoImpl)cx.newObject(scope, "_cryptoClass");
        export.setRuntime(runtime);
        ScriptableObject proto = (ScriptableObject)export.getPrototype();
        FunctionObject randomBytes = (FunctionObject)proto.get("randomBytes", (Scriptable)proto);
        randomBytes.setParentScope((Scriptable)export);
        FunctionObject pseudoRandomBytes = (FunctionObject)proto.get("pseudoRandomBytes", (Scriptable)proto);
        pseudoRandomBytes.setParentScope((Scriptable)export);
        ScriptableObject.defineClass((Scriptable)export, HashImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)export, MacImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)export, CipherImpl.class);
        ScriptableObject.defineClass((Scriptable)export, DecipherImpl.class);
        ScriptableObject.defineClass((Scriptable)export, SignImpl.class);
        ScriptableObject.defineClass((Scriptable)export, VerifyImpl.class);
        ScriptableObject.defineClass((Scriptable)export, SecureContext.class);
        ScriptableObject.defineClass((Scriptable)export, DHImpl.class);
        ScriptableObject.defineClass((Scriptable)export, DHGroupImpl.class);
        return export;
    }

    private static void loadCryptoService() {
        ServiceLoader<CryptoService> loc = ServiceLoader.load(CryptoService.class);
        if (loc.iterator().hasNext()) {
            if (log.isDebugEnabled()) {
                log.debug("Using crypto service implementation {}", (Object)cryptoService);
            }
            cryptoService = loc.iterator().next();
            cryptoProvider = cryptoService.getProvider();
        } else if (log.isDebugEnabled()) {
            log.debug("No crypto service available");
        }
    }

    public static ByteBuffer convertString(Object o, String encoding, Context cx, Scriptable scope) {
        if (o instanceof String) {
            Charset cs = Charsets.get().resolveCharset(encoding);
            return Utils.stringToBuffer((String)o, cs);
        }
        if (o instanceof Buffer.BufferImpl) {
            return ((Buffer.BufferImpl)((Object)o)).getBuffer();
        }
        throw Utils.makeError(cx, scope, "argument must be a String or Buffer");
    }

    public static void ensureCryptoService(Context cx, Scriptable scope) {
        if (cryptoService == null) {
            throw Utils.makeError(cx, scope, "Crypto service not available");
        }
    }

    public static CryptoService getCryptoService() {
        return cryptoService;
    }

    public static Provider getCryptoProvider() {
        return cryptoService == null ? null : cryptoService.getProvider();
    }

    static {
        Crypto.loadCryptoService();
    }

    public static class SecureContext
    extends ScriptableObject {
        public String getClassName() {
            return "SecureContext";
        }

        @JSConstructor
        public static void construct(Context cx, Object[] args, Function ctor, boolean inNew) {
            throw Utils.makeError(cx, (Scriptable)ctor, "SecureContext is not supported in Trireme");
        }
    }

    public static class CryptoImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_cryptoClass";
        private static final SecureRandom secureRandom = new SecureRandom();
        private static final Random pseudoRandom = new Random();
        private NodeRuntime runtime;

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSFunction
        public static Object randomBytes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return CryptoImpl.randomBytesCommon(cx, thisObj, args, func, secureRandom);
        }

        @JSFunction
        public static Object pseudoRandomBytes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return CryptoImpl.randomBytesCommon(cx, thisObj, args, func, pseudoRandom);
        }

        private static Object randomBytesCommon(Context cx, Scriptable thisObj, Object[] args, Function func, Random randomImpl) {
            CryptoImpl thisClass = (CryptoImpl)func.getParentScope();
            Number sizeNum = ArgUtils.objArg(args, 0, Number.class, false);
            if (sizeNum == null) {
                throw Utils.makeTypeError(cx, thisObj, "size must be a number");
            }
            if (sizeNum.longValue() < 0L) {
                throw Utils.makeTypeError(cx, thisObj, "size must be >= 0");
            }
            if (sizeNum.longValue() > 0x3FFFFFFFL) {
                throw Utils.makeTypeError(cx, thisObj, "size must be a valid integer");
            }
            Function callback = ArgUtils.objArg(args, 1, Function.class, false);
            byte[] randomBytes = new byte[sizeNum.intValue()];
            randomImpl.nextBytes(randomBytes);
            Buffer.BufferImpl randomBytesBuffer = Buffer.BufferImpl.newBuffer(cx, thisObj, randomBytes);
            if (callback != null) {
                thisClass.runtime.enqueueCallback(callback, (Scriptable)callback, thisObj, thisClass.runtime.getDomain(), new Object[]{null, randomBytesBuffer});
                return Undefined.instance;
            }
            return randomBytesBuffer;
        }

        @JSFunction
        public static Scriptable getCiphers(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return cx.newArray(thisObj, CryptoAlgorithms.get().getCiphers().toArray());
        }

        @JSFunction
        public static Scriptable getHashes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return cx.newArray(thisObj, HashImpl.SUPPORTED_ALGORITHMS.toArray());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JSFunction
        public static Scriptable PBKDF2(Context cx, Scriptable thisObj, Object[] args, Function func) {
            SecretKey key;
            String pw = ArgUtils.stringArg(args, 0);
            String saltStr = ArgUtils.stringArg(args, 1);
            int iterations = ArgUtils.intArg(args, 2);
            int keyLen = ArgUtils.intArg(args, 3);
            Function callback = ArgUtils.functionArg(args, 4, false);
            try {
                SecretKeyFactory kf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                char[] passphrase = pw.toCharArray();
                byte[] salt = saltStr.getBytes(Charsets.UTF8);
                PBEKeySpec spec = new PBEKeySpec(passphrase, salt, iterations, keyLen * 8);
                try {
                    key = kf.generateSecret(spec);
                }
                finally {
                    Arrays.fill(passphrase, '\u0000');
                }
            }
            catch (GeneralSecurityException gse) {
                if (callback == null) {
                    throw Utils.makeError(cx, thisObj, gse.toString());
                }
                callback.call(cx, thisObj, null, new Object[]{Utils.makeErrorObject(cx, thisObj, gse.toString())});
                return null;
            }
            Buffer.BufferImpl keyBuf = Buffer.BufferImpl.newBuffer(cx, thisObj, key.getEncoded());
            if (callback == null) {
                return keyBuf;
            }
            callback.call(cx, thisObj, null, new Object[]{Context.getUndefinedValue(), keyBuf});
            return null;
        }

        private void setRuntime(NodeRuntime runtime) {
            this.runtime = runtime;
        }
    }
}

