/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;

public class DNS
implements NodeModule {
    public String getModuleName() {
        return "dns";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, DNSImpl.class);
        DNSImpl dns = (DNSImpl)cx.newObject(scope, "_dnsClass");
        dns.initialize(runner);
        return dns;
    }

    public static class DNSImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_dnsClass";
        private NodeRuntime runner;

        public String getClassName() {
            return CLASS_NAME;
        }

        void initialize(NodeRuntime runner) {
            this.runner = runner;
        }

        @JSFunction
        public static void lookup(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String name = ArgUtils.stringArg(args, 0);
            int family = 4;
            Function callback = null;
            if (args.length == 2) {
                callback = ArgUtils.functionArg(args, 1, true);
            } else {
                family = ArgUtils.intArg(args, 1, 4);
                callback = ArgUtils.functionArg(args, 2, true);
            }
            DNSImpl dns = (DNSImpl)thisObj;
            dns.lookupInternal(cx, name, family, callback);
        }

        private void lookupInternal(Context cx, final String name, final int family, final Function callback) {
            if (family != 4 && family != 6) {
                throw Utils.makeError(cx, (Scriptable)this, "invalid argument: `family` must be 4 or 6'");
            }
            final Scriptable domain = this.runner.getDomain();
            this.runner.pin();
            this.runner.getAsyncPool().execute(new Runnable(){

                public void run() {
                    DNSImpl.this.doLookup(name, family, callback, domain);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doLookup(String name, int family, Function callback, Scriptable domain) {
            Context cx = Context.enter();
            try {
                InetAddress addr = InetAddress.getByName(name);
                if (family == 4 && !(addr instanceof Inet4Address) || family == 6 && !(addr instanceof Inet6Address)) {
                    this.invokeCallback(cx, callback, "EIO", null, family, domain);
                    return;
                }
                this.invokeCallback(cx, callback, null, addr.getHostAddress(), family, domain);
            }
            catch (UnknownHostException uhe) {
                this.invokeCallback(cx, callback, "ENOTFOUND", null, family, domain);
            }
            catch (IOException ioe) {
                this.invokeCallback(cx, callback, "EIO", null, family, domain);
            }
            finally {
                this.runner.unPin();
                Context.exit();
            }
        }

        private void invokeCallback(Context cx, Function callback, String code, String address, int family, Scriptable domain) {
            Scriptable err = null;
            if (code != null) {
                err = Utils.makeErrorObject(cx, (Scriptable)this, code, code);
            }
            this.runner.enqueueCallback(callback, (Scriptable)callback, (Scriptable)this, domain, new Object[]{err, address, family});
        }
    }
}

