/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.modules.Buffer;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderWrap
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger((String)DecoderWrap.class.getName());

    public String getModuleName() {
        return "decoder_wrap";
    }

    public Scriptable registerExports(Context cx, Scriptable global, NodeRuntime runtime) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)global, DecoderModuleImpl.class);
        Scriptable exports = cx.newObject(global, "_decoderWrapClass");
        ScriptableObject.defineClass((Scriptable)exports, DecoderImpl.class);
        return exports;
    }

    public static class DecoderImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "Decoder";
        private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
        private Charset charset;
        private CharsetDecoder decoder;
        private ByteBuffer remaining;

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSConstructor
        public static Object init(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
            String encoding = ArgUtils.stringArg(args, 0);
            Charset cs = Charsets.get().resolveCharset(encoding);
            if (cs == null) {
                throw new AssertionError((Object)("Charset not valid: " + encoding));
            }
            if (log.isTraceEnabled()) {
                log.trace("New charset decoder for {}: {}", (Object)encoding, (Object)cs);
            }
            DecoderImpl self = new DecoderImpl();
            self.charset = cs;
            return self;
        }

        @JSFunction
        public static Object decode(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ArgUtils.ensureArg(args, 0);
            Buffer.BufferImpl buf = args[0] == null ? null : ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            DecoderImpl self = (DecoderImpl)thisObj;
            return self.doDecode(buf, false);
        }

        @JSFunction
        public static Object end(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ArgUtils.ensureArg(args, 0);
            Buffer.BufferImpl buf = args[0] == null ? null : ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, false);
            DecoderImpl self = (DecoderImpl)thisObj;
            String result = self.doDecode(buf, true);
            self.decoder = null;
            return result;
        }

        private String doDecode(Buffer.BufferImpl buf, boolean lastChunk) {
            CoderResult result;
            if (this.decoder == null) {
                this.decoder = this.charset.newDecoder();
            }
            ByteBuffer inBuf = buf == null ? EMPTY : buf.getBuffer();
            ByteBuffer allIn = Utils.catBuffers(this.remaining, inBuf);
            CharBuffer out = CharBuffer.allocate((int)Math.ceil((float)inBuf.remaining() * this.decoder.averageCharsPerByte()));
            if (log.isTraceEnabled()) {
                log.trace("Decoding {} bytes", (Object)allIn.remaining());
            }
            do {
                if (!(result = this.decoder.decode(allIn, out, lastChunk)).isOverflow()) continue;
                out = Utils.doubleBuffer(out);
            } while (result.isOverflow());
            if (lastChunk) {
                do {
                    if (!(result = this.decoder.flush(out)).isOverflow()) continue;
                    out = Utils.doubleBuffer(out);
                } while (result.isOverflow());
            }
            if (allIn.hasRemaining()) {
                if (log.isTraceEnabled()) {
                    log.trace("Decoding leaves {} bytes left over", (Object)allIn.remaining());
                }
                this.remaining = allIn;
            } else {
                this.remaining = null;
            }
            if (out.position() > 0) {
                out.flip();
                if (log.isTraceEnabled()) {
                    log.trace("Returning {}", (Object)out.toString());
                }
                return out.toString();
            }
            if (log.isTraceEnabled()) {
                log.trace("Returning nothing");
            }
            return "";
        }
    }

    public static class DecoderModuleImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_decoderWrapClass";

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSFunction
        public static Object isEncoding(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String encoding = ArgUtils.stringArg(args, 0);
            boolean valid = Charsets.get().getCharset(encoding) != null;
            return Context.javaToJS((Object)valid, (Scriptable)func);
        }
    }
}

