/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NetworkPolicy;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.Referenceable;
import io.apigee.trireme.net.NetUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.ArrayDeque;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPWrap
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(UDPWrap.class);

    public String getModuleName() {
        return "udp_wrap";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runtime) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject exports = (ScriptableObject)cx.newObject(scope);
        exports.setPrototype(scope);
        exports.setParentScope(null);
        ScriptableObject.defineClass((Scriptable)exports, Referenceable.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)exports, UDPImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)exports, QueuedWrite.class);
        return exports;
    }

    public static class QueuedWrite
    extends ScriptableObject {
        public static final String CLASS_NAME = "_writeWrap";
        byte[] buf;
        int offset;
        int length;
        Function onComplete;
        InetSocketAddress address;

        void initialize(byte[] buf, int offset, int length, InetSocketAddress address) {
            this.buf = buf;
            this.offset = offset;
            this.length = length;
            this.address = address;
        }

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSSetter(value="oncomplete")
        public void setOnComplete(Function c) {
            this.onComplete = c;
        }

        @JSGetter(value="oncomplete")
        public Function getOnComplete() {
            return this.onComplete;
        }
    }

    public static class UDPImpl
    extends Referenceable {
        public static final String CLASS_NAME = "UDP";
        private Function onMessage;
        private DatagramSocket socket;
        private final ArrayDeque<QueuedWrite> writeQueue = new ArrayDeque();
        private Thread readThread;
        private ScriptRunner runner;

        @JSConstructor
        public static Object newUDPImpl(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
            UDPImpl udp = new UDPImpl();
            udp.runner = UDPImpl.getRunner(cx);
            return udp;
        }

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSSetter(value="onmessage")
        public void setOnMessage(Function onmessage) {
            this.onMessage = onmessage;
        }

        @JSGetter(value="onmessage")
        public Object getOnMessage() {
            return this.onMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JSFunction
        public static int bind(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String address = ArgUtils.stringArg(args, 0);
            int port = ArgUtils.intArg(args, 1);
            int options = ArgUtils.intArg(args, 2);
            UDPImpl self = (UDPImpl)thisObj;
            boolean success = false;
            try {
                InetSocketAddress targetAddress = new InetSocketAddress(address, port);
                NetworkPolicy netPolicy = self.getNetworkPolicy();
                if (netPolicy != null && !netPolicy.allowListening(targetAddress)) {
                    log.debug("Address {} not allowed by network policy", (Object)targetAddress);
                    UDPImpl.setErrno("EINVAL");
                    int n = -1;
                    return n;
                }
                UDPImpl.clearErrno();
                self.socket = new DatagramSocket(targetAddress);
                if (log.isDebugEnabled()) {
                    log.debug("UDP socket {} bound to {}}", (Object)self.socket, (Object)targetAddress);
                }
                success = true;
                int n = 0;
                return n;
            }
            catch (BindException be) {
                log.debug("Error listening: {}", (Throwable)be);
                UDPImpl.setErrno("EADDRINUSE");
                int n = -1;
                return n;
            }
            catch (IOException ioe) {
                log.debug("Error on bind: {}", (Throwable)ioe);
                UDPImpl.setErrno("EIO");
                int n = -1;
                return n;
            }
            finally {
                if (!success && self.socket != null) {
                    self.socket.close();
                }
            }
        }

        @JSFunction
        public static int bind6(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return UDPImpl.bind(cx, thisObj, args, func);
        }

        @JSFunction
        public void close() {
            super.close();
            if (this.socket != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing {}", (Object)this.socket);
                }
                this.socket.close();
            }
        }

        @JSFunction
        public static Object send(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ArgUtils.ensureArg(args, 0);
            final Buffer.BufferImpl buf = (Buffer.BufferImpl)((Object)args[0]);
            int offset = ArgUtils.intArg(args, 1);
            int length = ArgUtils.intArg(args, 2);
            int port = ArgUtils.intArg(args, 3);
            String host = ArgUtils.stringArg(args, 4);
            final UDPImpl self = (UDPImpl)thisObj;
            final InetSocketAddress address = new InetSocketAddress(host, port);
            NetworkPolicy netPolicy = self.getNetworkPolicy();
            if (netPolicy != null && !netPolicy.allowListening(address)) {
                log.debug("Address {} not allowed by network policy", (Object)address);
                UDPImpl.setErrno("EINVAL");
                return -1;
            }
            UDPImpl.clearErrno();
            final QueuedWrite qw = (QueuedWrite)cx.newObject(thisObj, "_writeWrap");
            qw.initialize(buf.getArray(), buf.getArrayOffset() + offset, length, address);
            final DatagramPacket packet = new DatagramPacket(qw.buf, qw.offset, qw.length, address.getAddress(), port);
            final Scriptable domain = self.runner.getDomain();
            self.runner.getAsyncPool().execute(new Runnable(){

                public void run() {
                    block5: {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug("Sending UDP packet {} to {} with {} ", new Object[]{packet, address, self.socket});
                            }
                            self.socket.send(packet);
                            if (qw.onComplete != null) {
                                self.runner.enqueueCallback(qw.onComplete, (Scriptable)self, null, domain, new Object[]{0, self, qw, buf});
                            }
                        }
                        catch (IOException ioe) {
                            if (log.isDebugEnabled()) {
                                log.debug("Error sending UDP packet to {} with {}: {}", new Object[]{address, self.socket, ioe});
                            }
                            if (qw.onComplete == null) break block5;
                            self.runner.enqueueCallback(qw.onComplete, (Scriptable)self, null, domain, new Object[]{"EIO", self, qw, buf});
                        }
                    }
                }
            });
            return qw;
        }

        @JSFunction
        public static Object send6(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return UDPImpl.send(cx, thisObj, args, func);
        }

        @JSFunction
        public void recvStart() {
            final UDPImpl self = this;
            final Scriptable domain = this.runner.getDomain();
            UDPImpl.clearErrno();
            if (this.readThread == null) {
                this.readThread = new Thread(new Runnable(){

                    public void run() {
                        if (log.isDebugEnabled()) {
                            log.debug("Starting to receive UDP packets from {}", (Object)UDPImpl.this.socket);
                        }
                        try {
                            int recvLen = UDPImpl.this.socket.getReceiveBufferSize();
                            final byte[] recvBuf = new byte[recvLen];
                            while (true) {
                                final DatagramPacket packet = new DatagramPacket(recvBuf, recvLen);
                                UDPImpl.this.socket.receive(packet);
                                if (log.isDebugEnabled()) {
                                    log.debug("Received {}", (Object)packet);
                                }
                                if (packet.getLength() <= 0) continue;
                                UDPImpl.this.runner.enqueueTask(new ScriptTask(){

                                    public void execute(Context cx, Scriptable scope) {
                                        Buffer.BufferImpl buf = Buffer.BufferImpl.newBuffer(cx, scope, recvBuf, packet.getOffset(), packet.getLength());
                                        if (UDPImpl.this.onMessage != null) {
                                            Scriptable rinfo = cx.newObject((Scriptable)self);
                                            rinfo.put("port", rinfo, (Object)packet.getPort());
                                            rinfo.put("address", rinfo, (Object)packet.getAddress().getHostAddress());
                                            UDPImpl.this.onMessage.call(cx, (Scriptable)UDPImpl.this.onMessage, (Scriptable)self, new Object[]{self, buf, 0, packet.getLength(), rinfo});
                                        }
                                    }
                                }, domain);
                            }
                        }
                        catch (IOException ioe) {
                            if (log.isDebugEnabled()) {
                                log.debug("Error receiving from UDP socket {}: exiting", (Object)UDPImpl.this.socket);
                            }
                            return;
                        }
                    }
                }, "Trireme UDP read thread");
                this.ref();
                this.readThread.setDaemon(true);
                this.readThread.start();
            }
        }

        @JSFunction
        public void recvStop() {
            this.unref();
            UDPImpl.clearErrno();
            if (this.readThread != null) {
                this.readThread.interrupt();
                this.readThread = null;
            }
        }

        @JSFunction
        public static Object getsockname(Context cx, Scriptable thisObj, Object[] args, Function func) {
            UDPImpl self = (UDPImpl)thisObj;
            UDPImpl.clearErrno();
            InetSocketAddress addr = (InetSocketAddress)self.socket.getLocalSocketAddress();
            if (addr == null) {
                return null;
            }
            return NetUtils.formatAddress(addr.getAddress(), addr.getPort(), cx, thisObj);
        }

        @JSFunction
        public static int addMembership(Context cx, Scriptable thisObj, Object[] args, Function func) {
            UDPImpl.setErrno("EINVAL");
            return -1;
        }

        @JSFunction
        public static int dropMembership(Context cx, Scriptable thisObj, Object[] args, Function func) {
            UDPImpl.setErrno("EINVAL");
            return -1;
        }

        @JSFunction
        public static int setMulticastTTL(Context cx, Scriptable thisObj, Object[] args, Function func) {
            UDPImpl.setErrno("EINVAL");
            return -1;
        }

        @JSFunction
        public static int setMulticastLoopback(Context cx, Scriptable thisObj, Object[] args, Function func) {
            UDPImpl.setErrno("EINVAL");
            return -1;
        }

        @JSFunction
        public int setBroadcast(int on) {
            try {
                UDPImpl.clearErrno();
                if (this.socket != null) {
                    this.socket.setBroadcast(on != 0);
                }
                return 0;
            }
            catch (SocketException se) {
                log.debug("Error setting broadcast flag to {}: {}", (Object)on, (Object)se);
                UDPImpl.setErrno("EIO");
                return -1;
            }
        }

        @JSFunction
        public static int setTTL(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return 0;
        }

        private NetworkPolicy getNetworkPolicy() {
            if (UDPImpl.getRunner().getSandbox() == null) {
                return null;
            }
            return UDPImpl.getRunner().getSandbox().getNetworkPolicy();
        }
    }
}

