/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.internal.CryptoAlgorithms;
import io.apigee.trireme.core.internal.KeyGenerator;
import io.apigee.trireme.core.modules.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class AbstractCipherImpl
extends ScriptableObject {
    protected static final byte[] EMPTY = new byte[0];
    private Cipher cipher;
    private String algorithm;
    protected boolean autoPadding = true;
    private ByteBuffer key;
    private ByteBuffer iv;
    private int mode;

    protected boolean init(Context cx, Object[] args, int mode) {
        MessageDigest digest;
        String algoName = ArgUtils.stringArg(args, 0);
        Buffer.BufferImpl pwBuf = ArgUtils.objArg(args, 1, Buffer.BufferImpl.class, true);
        this.algorithm = algoName;
        this.mode = mode;
        CryptoAlgorithms.Spec spec = CryptoAlgorithms.get().getAlgorithm(algoName);
        if (spec == null) {
            throw Utils.makeError(cx, (Scriptable)this, "Unknown cipher " + algoName);
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ne) {
            throw new AssertionError((Object)ne);
        }
        KeyGenerator.Key generatedKey = KeyGenerator.generateKey(digest, pwBuf.getArray(), pwBuf.getArrayOffset(), pwBuf.getLength(), spec.getKeyLen(), spec.getIvLen(), 1);
        this.key = ByteBuffer.wrap(generatedKey.getKey());
        if (generatedKey.getIv() != null) {
            this.iv = ByteBuffer.wrap(generatedKey.getIv());
        }
        return true;
    }

    protected boolean initiv(Context cx, Object[] args, int mode) {
        String algoName = ArgUtils.stringArg(args, 0);
        Buffer.BufferImpl keyBuf = ArgUtils.objArg(args, 1, Buffer.BufferImpl.class, true);
        Buffer.BufferImpl ivBuf = ArgUtils.objArg(args, 2, Buffer.BufferImpl.class, false);
        this.algorithm = algoName;
        this.mode = mode;
        CryptoAlgorithms.Spec spec = CryptoAlgorithms.get().getAlgorithm(algoName);
        if (spec == null) {
            throw Utils.makeError(cx, (Scriptable)this, "Unknown cipher " + algoName);
        }
        this.key = Utils.duplicateBuffer(keyBuf.getBuffer());
        if (ivBuf != null) {
            this.iv = Utils.duplicateBuffer(ivBuf.getBuffer());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCipher(Context cx) {
        if (this.cipher == null) {
            if (this.key == null) {
                throw Utils.makeError(cx, (Scriptable)this, "Cipher was not initialized");
            }
            try {
                CryptoAlgorithms.Spec spec = CryptoAlgorithms.get().getAlgorithm(this.algorithm);
                try {
                    this.cipher = Cipher.getInstance(spec.getFullName(this.autoPadding));
                }
                catch (NoSuchAlgorithmException e) {
                    throw Utils.makeError(cx, (Scriptable)this, "No such algorithm: " + this.algorithm);
                }
                catch (NoSuchPaddingException e) {
                    throw Utils.makeError(cx, (Scriptable)this, "No such algorithm: " + this.algorithm + " with padding " + this.autoPadding);
                }
                try {
                    SecretKeySpec jcaKey = new SecretKeySpec(this.key.array(), this.key.arrayOffset(), this.key.remaining(), spec.getAlgo());
                    if (this.iv != null && this.iv.hasRemaining()) {
                        IvParameterSpec ivSpec = new IvParameterSpec(this.iv.array(), this.iv.arrayOffset(), this.iv.remaining());
                        this.cipher.init(this.mode, (Key)jcaKey, ivSpec);
                    } else {
                        this.cipher.init(this.mode, jcaKey);
                    }
                }
                catch (GeneralSecurityException gse) {
                    throw Utils.makeError(cx, (Scriptable)this, "Error initializing cipher: " + gse);
                }
            }
            finally {
                if (this.key != null) {
                    Utils.zeroBuffer(this.key);
                    this.key = null;
                }
                if (this.iv != null) {
                    Utils.zeroBuffer(this.iv);
                    this.iv = null;
                }
            }
        }
    }

    protected Object update(Context cx, Object[] args) {
        ByteBuffer buf;
        ArgUtils.ensureArg(args, 0);
        this.initCipher(cx);
        if (args[0] instanceof String) {
            String enc = ArgUtils.stringArg(args, 1, "binary");
            buf = Utils.stringToBuffer((String)args[0], Charsets.get().resolveCharset(enc));
        } else {
            Buffer.BufferImpl jsBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            buf = jsBuf.getBuffer();
        }
        byte[] out = this.cipher.update(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        if (out == null) {
            return Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, EMPTY);
        }
        return Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, out);
    }

    protected Object doFinal(Context cx) {
        this.initCipher(cx);
        try {
            byte[] out = this.cipher.doFinal();
            if (out == null) {
                return Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, EMPTY);
            }
            return Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, out);
        }
        catch (GeneralSecurityException gse) {
            throw Utils.makeError(cx, (Scriptable)this, gse.toString());
        }
    }
}

