/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.modules.Buffer;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class HashImpl
extends ScriptableObject {
    public static final String CLASS_NAME = "Hash";
    public static final HashMap<String, String> MD_ALGORITHMS = new HashMap();
    public static final Set<String> SUPPORTED_ALGORITHMS;
    private MessageDigest messageDigest;

    public String getClassName() {
        return CLASS_NAME;
    }

    @JSConstructor
    public static Object hashConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        HashImpl ret = inNewExpr ? new HashImpl() : (HashImpl)cx.newObject((Scriptable)ctorObj, CLASS_NAME);
        ret.initializeHash(cx, args, ctorObj);
        return ret;
    }

    private void initializeHash(Context cx, Object[] args, Function ctorObj) {
        String nodeAlgorithm = ArgUtils.stringArg(args, 0);
        String jceAlgorithm = MD_ALGORITHMS.get(nodeAlgorithm);
        if (jceAlgorithm == null) {
            jceAlgorithm = nodeAlgorithm;
        }
        try {
            this.messageDigest = MessageDigest.getInstance(jceAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw Utils.makeError(cx, (Scriptable)ctorObj, "Digest method not supported");
        }
    }

    @JSFunction
    public static void update(Context cx, Scriptable thisObj, Object[] args, Function func) {
        HashImpl thisClass = (HashImpl)thisObj;
        ArgUtils.ensureArg(args, 0);
        String encoding = ArgUtils.stringArg(args, 1, null);
        if (args[0] instanceof String) {
            ByteBuffer bb = Utils.stringToBuffer(ArgUtils.stringArg(args, 0), Charsets.get().resolveCharset(encoding));
            thisClass.messageDigest.update(bb.array(), bb.arrayOffset(), bb.limit());
        } else {
            Buffer.BufferImpl buf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            thisClass.messageDigest.update(buf.getArray(), buf.getArrayOffset(), buf.getLength());
        }
    }

    @JSFunction
    public static Object digest(Context cx, Scriptable thisObj, Object[] args, Function func) {
        HashImpl thisClass = (HashImpl)thisObj;
        String encoding = ArgUtils.stringArg(args, 0, null);
        byte[] digest = thisClass.messageDigest.digest();
        if (encoding == null || "buffer".equals(encoding)) {
            return Buffer.BufferImpl.newBuffer(cx, thisObj, digest);
        }
        ByteBuffer bb = ByteBuffer.wrap(digest);
        return Utils.bufferToString(bb, Charsets.get().resolveCharset(encoding));
    }

    static {
        MD_ALGORITHMS.put("md2", "MD2");
        MD_ALGORITHMS.put("md5", "MD5");
        MD_ALGORITHMS.put("sha1", "SHA-1");
        MD_ALGORITHMS.put("sha256", "SHA-256");
        MD_ALGORITHMS.put("sha384", "SHA-384");
        MD_ALGORITHMS.put("sha512", "SHA-512");
        SUPPORTED_ALGORITHMS = MD_ALGORITHMS.keySet();
    }
}

