/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.parboiled.BaseParser;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.pegdown.plugins.BlockPluginParser;
import org.pegdown.plugins.InlinePluginParser;

public class PegDownPlugins {
    private final Rule[] inlinePluginRules;
    private final Rule[] blockPluginRules;
    public static PegDownPlugins NONE = PegDownPlugins.builder().build();

    private PegDownPlugins(Rule[] inlinePluginRules, Rule[] blockPluginRules) {
        this.inlinePluginRules = inlinePluginRules;
        this.blockPluginRules = blockPluginRules;
    }

    public Rule[] getInlinePluginRules() {
        return this.inlinePluginRules;
    }

    public Rule[] getBlockPluginRules() {
        return this.blockPluginRules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PegDownPlugins like) {
        return PegDownPlugins.builder().withInlinePluginRules(like.getInlinePluginRules()).withBlockPluginRules(like.getBlockPluginRules());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final List<Rule> inlinePluginRules = new ArrayList<Rule>();
        private final List<Rule> blockPluginRules = new ArrayList<Rule>();

        public Builder withInlinePluginRules(Rule ... inlinePlugins) {
            this.inlinePluginRules.addAll(Arrays.asList(inlinePlugins));
            return this;
        }

        public Builder withBlockPluginRules(Rule ... blockPlugins) {
            this.blockPluginRules.addAll(Arrays.asList(blockPlugins));
            return this;
        }

        public Builder withPlugin(Class<? extends BaseParser<Object>> pluginParser, Object ... arguments) {
            if (!InlinePluginParser.class.isAssignableFrom(pluginParser) && !BlockPluginParser.class.isAssignableFrom(pluginParser)) {
                throw new IllegalArgumentException("Parser plugin must implement a parser plugin interface to be useful");
            }
            BaseParser parser = Parboiled.createParser(pluginParser, (Object[])arguments);
            if (parser instanceof InlinePluginParser) {
                this.withInlinePluginRules(((InlinePluginParser)parser).inlinePluginRules());
            }
            if (parser instanceof BlockPluginParser) {
                this.withBlockPluginRules(((BlockPluginParser)parser).blockPluginRules());
            }
            return this;
        }

        public PegDownPlugins build() {
            return new PegDownPlugins(this.inlinePluginRules.toArray(new Rule[0]), this.blockPluginRules.toArray(new Rule[0]));
        }
    }
}

