/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.ContainedPacket;
import org.vafer.jdeb.shaded.bc.bcpg.Packet;
import org.vafer.jdeb.shaded.bc.bcpg.SignaturePacket;
import org.vafer.jdeb.shaded.bc.bcpg.TrustPacket;
import org.vafer.jdeb.shaded.bc.bcpg.UserAttributePacket;
import org.vafer.jdeb.shaded.bc.bcpg.UserIDPacket;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPublicKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPUserAttributeSubpacketVector;

public abstract class PGPKeyRing {
    PGPKeyRing() {
    }

    static BCPGInputStream wrap(InputStream inputStream) {
        if (inputStream instanceof BCPGInputStream) {
            return (BCPGInputStream)inputStream;
        }
        return new BCPGInputStream(inputStream);
    }

    static TrustPacket readOptionalTrustPacket(BCPGInputStream bCPGInputStream) throws IOException {
        return bCPGInputStream.nextPacketTag() == 12 ? (TrustPacket)bCPGInputStream.readPacket() : null;
    }

    static List readSignaturesAndTrust(BCPGInputStream bCPGInputStream) throws IOException {
        try {
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            while (bCPGInputStream.nextPacketTag() == 2) {
                SignaturePacket signaturePacket = (SignaturePacket)bCPGInputStream.readPacket();
                TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(bCPGInputStream);
                arrayList.add(new PGPSignature(signaturePacket, trustPacket));
            }
            return arrayList;
        }
        catch (PGPException pGPException) {
            throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
        }
    }

    static void readUserIDs(BCPGInputStream bCPGInputStream, List list, List list2, List list3) throws IOException {
        while (bCPGInputStream.nextPacketTag() == 13 || bCPGInputStream.nextPacketTag() == 17) {
            ContainedPacket containedPacket;
            Packet packet = bCPGInputStream.readPacket();
            if (packet instanceof UserIDPacket) {
                containedPacket = (UserIDPacket)packet;
                list.add(((UserIDPacket)containedPacket).getID());
            } else {
                containedPacket = (UserAttributePacket)packet;
                list.add(new PGPUserAttributeSubpacketVector(((UserAttributePacket)containedPacket).getSubpackets()));
            }
            list2.add(PGPKeyRing.readOptionalTrustPacket(bCPGInputStream));
            list3.add(PGPKeyRing.readSignaturesAndTrust(bCPGInputStream));
        }
    }

    public abstract PGPPublicKey getPublicKey();

    public abstract Iterator getPublicKeys();

    public abstract PGPPublicKey getPublicKey(long var1);

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract byte[] getEncoded() throws IOException;
}

