/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.math.ec;

import java.math.BigInteger;
import org.vafer.jdeb.shaded.bc.math.ec.ECConstants;
import org.vafer.jdeb.shaded.bc.math.ec.ECCurve;
import org.vafer.jdeb.shaded.bc.math.ec.ECFieldElement;
import org.vafer.jdeb.shaded.bc.math.ec.PreCompInfo;

public abstract class ECPoint {
    protected static ECFieldElement[] EMPTY_ZS = new ECFieldElement[0];
    protected ECCurve curve;
    protected ECFieldElement x;
    protected ECFieldElement y;
    protected ECFieldElement[] zs;
    protected boolean withCompression;
    protected PreCompInfo preCompInfo = null;

    protected static ECFieldElement[] getInitialZCoords(ECCurve eCCurve) {
        int n = null == eCCurve ? 0 : eCCurve.getCoordinateSystem();
        switch (n) {
            case 0: 
            case 5: {
                return EMPTY_ZS;
            }
        }
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(ECConstants.ONE);
        switch (n) {
            case 1: 
            case 2: 
            case 6: {
                return new ECFieldElement[]{eCFieldElement};
            }
            case 3: {
                return new ECFieldElement[]{eCFieldElement, eCFieldElement, eCFieldElement};
            }
            case 4: {
                return new ECFieldElement[]{eCFieldElement, eCCurve.getA()};
            }
        }
        throw new IllegalArgumentException("unknown coordinate system");
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this(eCCurve, eCFieldElement, eCFieldElement2, ECPoint.getInitialZCoords(eCCurve));
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
        this.zs = eCFieldElementArray;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    protected int getCurveCoordinateSystem() {
        return null == this.curve ? 0 : this.curve.getCoordinateSystem();
    }

    public ECFieldElement getX() {
        return this.normalize().getXCoord();
    }

    public ECFieldElement getY() {
        return this.normalize().getYCoord();
    }

    public ECFieldElement getAffineXCoord() {
        this.checkNormalized();
        return this.getXCoord();
    }

    public ECFieldElement getAffineYCoord() {
        this.checkNormalized();
        return this.getYCoord();
    }

    public ECFieldElement getXCoord() {
        return this.x;
    }

    public ECFieldElement getYCoord() {
        return this.y;
    }

    public ECFieldElement getZCoord(int n) {
        return n < 0 || n >= this.zs.length ? null : this.zs[n];
    }

    public ECFieldElement[] getZCoords() {
        int n = this.zs.length;
        if (n == 0) {
            return this.zs;
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[n];
        System.arraycopy(this.zs, 0, eCFieldElementArray, 0, n);
        return eCFieldElementArray;
    }

    protected ECFieldElement getRawXCoord() {
        return this.x;
    }

    protected ECFieldElement getRawYCoord() {
        return this.y;
    }

    protected void checkNormalized() {
        if (!this.isNormalized()) {
            throw new IllegalStateException("point not in normal form");
        }
    }

    public boolean isNormalized() {
        int n = this.getCurveCoordinateSystem();
        return n == 0 || n == 5 || this.isInfinity() || this.zs[0].bitLength() == 1;
    }

    public ECPoint normalize() {
        if (this.isInfinity()) {
            return this;
        }
        switch (this.getCurveCoordinateSystem()) {
            case 0: 
            case 5: {
                return this;
            }
        }
        ECFieldElement eCFieldElement = this.getZCoord(0);
        if (eCFieldElement.bitLength() == 1) {
            return this;
        }
        return this.normalize(eCFieldElement.invert());
    }

    ECPoint normalize(ECFieldElement eCFieldElement) {
        switch (this.getCurveCoordinateSystem()) {
            case 1: 
            case 6: {
                return this.createScaledPoint(eCFieldElement, eCFieldElement);
            }
            case 2: 
            case 3: 
            case 4: {
                ECFieldElement eCFieldElement2 = eCFieldElement.square();
                ECFieldElement eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement);
                return this.createScaledPoint(eCFieldElement2, eCFieldElement3);
            }
        }
        throw new IllegalStateException("not a projective coordinate system");
    }

    protected ECPoint createScaledPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord().multiply(eCFieldElement2), this.withCompression);
    }

    public boolean isInfinity() {
        return this.x == null || this.y == null || this.zs.length > 0 && this.zs[0].isZero();
    }

    public boolean isCompressed() {
        return this.withCompression;
    }

    public boolean equals(ECPoint eCPoint) {
        if (null == eCPoint) {
            return false;
        }
        ECCurve eCCurve = this.getCurve();
        ECCurve eCCurve2 = eCPoint.getCurve();
        boolean bl = null == eCCurve;
        boolean bl2 = null == eCCurve2;
        boolean bl3 = this.isInfinity();
        boolean bl4 = eCPoint.isInfinity();
        if (bl3 || bl4) {
            return bl3 && bl4 && (bl || bl2 || eCCurve.equals(eCCurve2));
        }
        ECPoint eCPoint2 = this;
        ECPoint eCPoint3 = eCPoint;
        if (!bl || !bl2) {
            if (bl) {
                eCPoint3 = eCPoint3.normalize();
            } else if (bl2) {
                eCPoint2 = eCPoint2.normalize();
            } else {
                if (!eCCurve.equals(eCCurve2)) {
                    return false;
                }
                ECPoint[] eCPointArray = new ECPoint[]{this, eCCurve.importPoint(eCPoint3)};
                eCCurve.normalizeAll(eCPointArray);
                eCPoint2 = eCPointArray[0];
                eCPoint3 = eCPointArray[1];
            }
        }
        return eCPoint2.getXCoord().equals(eCPoint3.getXCoord()) && eCPoint2.getYCoord().equals(eCPoint3.getYCoord());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        return this.equals((ECPoint)object);
    }

    public int hashCode() {
        int n;
        ECCurve eCCurve = this.getCurve();
        int n2 = n = null == eCCurve ? 0 : ~eCCurve.hashCode();
        if (!this.isInfinity()) {
            ECPoint eCPoint = this.normalize();
            n ^= eCPoint.getXCoord().hashCode() * 17;
            n ^= eCPoint.getYCoord().hashCode() * 257;
        }
        return n;
    }

    public String toString() {
        if (this.isInfinity()) {
            return "INF";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.getRawXCoord());
        stringBuffer.append(',');
        stringBuffer.append(this.getRawYCoord());
        for (int i = 0; i < this.zs.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(this.zs[i]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.withCompression);
    }

    public byte[] getEncoded(boolean bl) {
        if (this.isInfinity()) {
            return new byte[1];
        }
        ECPoint eCPoint = this.normalize();
        byte[] byArray = eCPoint.getXCoord().getEncoded();
        if (bl) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = (byte)(eCPoint.getCompressionYTilde() ? 3 : 2);
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            return byArray2;
        }
        byte[] byArray3 = eCPoint.getYCoord().getEncoded();
        byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
        byArray4[0] = 4;
        System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
        return byArray4;
    }

    protected abstract boolean getCompressionYTilde();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint subtract(ECPoint var1);

    public ECPoint timesPow2(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("'e' cannot be negative");
        }
        ECPoint eCPoint = this;
        while (--n >= 0) {
            eCPoint = eCPoint.twice();
        }
        return eCPoint;
    }

    public abstract ECPoint twice();

    public ECPoint twicePlus(ECPoint eCPoint) {
        return this.twice().add(eCPoint);
    }

    public ECPoint threeTimes() {
        return this.twicePlus(this);
    }

    public ECPoint multiply(BigInteger bigInteger) {
        return this.getCurve().getMultiplier().multiply(this, bigInteger);
    }

    public static class F2m
    extends ECPoint {
        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            this(eCCurve, eCFieldElement, eCFieldElement2, false);
        }

        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
            if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            if (eCFieldElement != null) {
                ECFieldElement.F2m.checkFieldElements(this.x, this.y);
                if (eCCurve != null) {
                    ECFieldElement.F2m.checkFieldElements(this.x, this.curve.getA());
                }
            }
            this.withCompression = bl;
        }

        F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
            this.withCompression = bl;
        }

        public ECFieldElement getYCoord() {
            int n = this.getCurveCoordinateSystem();
            switch (n) {
                case 5: 
                case 6: {
                    ECFieldElement eCFieldElement;
                    if (this.isInfinity() || this.x.isZero()) {
                        return this.y;
                    }
                    ECFieldElement eCFieldElement2 = this.x;
                    ECFieldElement eCFieldElement3 = this.y;
                    ECFieldElement eCFieldElement4 = eCFieldElement3.subtract(eCFieldElement2).multiply(eCFieldElement2);
                    if (6 == n && (eCFieldElement = this.zs[0]).bitLength() != 1) {
                        eCFieldElement4 = eCFieldElement4.divide(eCFieldElement);
                    }
                    return eCFieldElement4;
                }
            }
            return this.y;
        }

        protected boolean getCompressionYTilde() {
            ECFieldElement eCFieldElement = this.getRawXCoord();
            if (eCFieldElement.isZero()) {
                return false;
            }
            ECFieldElement eCFieldElement2 = this.getRawYCoord();
            switch (this.getCurveCoordinateSystem()) {
                case 5: 
                case 6: {
                    return eCFieldElement2.subtract(eCFieldElement).testBitZero();
                }
            }
            return eCFieldElement2.divide(eCFieldElement).testBitZero();
        }

        private static void checkPoints(ECPoint eCPoint, ECPoint eCPoint2) {
            if (eCPoint.curve != eCPoint2.curve) {
                throw new IllegalArgumentException("Only points on the same curve can be added or subtracted");
            }
        }

        public ECPoint add(ECPoint eCPoint) {
            F2m.checkPoints(this, eCPoint);
            return this.addSimple((F2m)eCPoint);
        }

        public F2m addSimple(F2m f2m) {
            if (this.isInfinity()) {
                return f2m;
            }
            if (f2m.isInfinity()) {
                return this;
            }
            ECCurve eCCurve = this.getCurve();
            int n = eCCurve.getCoordinateSystem();
            ECFieldElement eCFieldElement = this.x;
            ECFieldElement eCFieldElement2 = f2m.x;
            switch (n) {
                case 0: {
                    ECFieldElement eCFieldElement3 = this.y;
                    ECFieldElement eCFieldElement4 = f2m.y;
                    if (eCFieldElement.equals(eCFieldElement2)) {
                        if (eCFieldElement3.equals(eCFieldElement4)) {
                            return (F2m)this.twice();
                        }
                        return (F2m)eCCurve.getInfinity();
                    }
                    ECFieldElement eCFieldElement5 = eCFieldElement.add(eCFieldElement2);
                    ECFieldElement eCFieldElement6 = eCFieldElement3.add(eCFieldElement4).divide(eCFieldElement5);
                    ECFieldElement eCFieldElement7 = eCFieldElement6.square().add(eCFieldElement6).add(eCFieldElement5).add(eCCurve.getA());
                    ECFieldElement eCFieldElement8 = eCFieldElement6.multiply(eCFieldElement.add(eCFieldElement7)).add(eCFieldElement7).add(eCFieldElement3);
                    return new F2m(eCCurve, eCFieldElement7, eCFieldElement8, this.withCompression);
                }
                case 1: {
                    ECFieldElement eCFieldElement9 = this.y;
                    ECFieldElement eCFieldElement10 = this.zs[0];
                    ECFieldElement eCFieldElement11 = f2m.y;
                    ECFieldElement eCFieldElement12 = f2m.zs[0];
                    boolean bl = eCFieldElement12.bitLength() == 1;
                    ECFieldElement eCFieldElement13 = eCFieldElement10.multiply(eCFieldElement11);
                    ECFieldElement eCFieldElement14 = bl ? eCFieldElement9 : eCFieldElement9.multiply(eCFieldElement12);
                    ECFieldElement eCFieldElement15 = eCFieldElement13.subtract(eCFieldElement14);
                    ECFieldElement eCFieldElement16 = eCFieldElement10.multiply(eCFieldElement2);
                    ECFieldElement eCFieldElement17 = bl ? eCFieldElement : eCFieldElement.multiply(eCFieldElement12);
                    ECFieldElement eCFieldElement18 = eCFieldElement16.subtract(eCFieldElement17);
                    if (eCFieldElement16.equals(eCFieldElement17)) {
                        if (eCFieldElement13.equals(eCFieldElement14)) {
                            return (F2m)this.twice();
                        }
                        return (F2m)eCCurve.getInfinity();
                    }
                    ECFieldElement eCFieldElement19 = eCFieldElement18.square();
                    ECFieldElement eCFieldElement20 = bl ? eCFieldElement10 : eCFieldElement10.multiply(eCFieldElement12);
                    ECFieldElement eCFieldElement21 = eCFieldElement15.square().add(eCFieldElement15.multiply(eCFieldElement18).add(eCFieldElement19.multiply(eCCurve.getA()))).multiply(eCFieldElement20).add(eCFieldElement18.multiply(eCFieldElement19));
                    ECFieldElement eCFieldElement22 = eCFieldElement18.multiply(eCFieldElement21);
                    ECFieldElement eCFieldElement23 = bl ? eCFieldElement19 : eCFieldElement19.multiply(eCFieldElement12);
                    ECFieldElement eCFieldElement24 = eCFieldElement23.multiply(eCFieldElement15.multiply(eCFieldElement).add(eCFieldElement9.multiply(eCFieldElement18))).add(eCFieldElement21.multiply(eCFieldElement15.add(eCFieldElement18)));
                    ECFieldElement eCFieldElement25 = eCFieldElement19.multiply(eCFieldElement18).multiply(eCFieldElement20);
                    return new F2m(eCCurve, eCFieldElement22, eCFieldElement24, new ECFieldElement[]{eCFieldElement25}, this.withCompression);
                }
                case 6: {
                    ECFieldElement eCFieldElement26;
                    ECFieldElement eCFieldElement27;
                    ECFieldElement eCFieldElement28;
                    if (eCFieldElement.isZero()) {
                        return f2m.addSimple(this);
                    }
                    ECFieldElement eCFieldElement29 = this.y;
                    ECFieldElement eCFieldElement30 = this.zs[0];
                    ECFieldElement eCFieldElement31 = f2m.y;
                    ECFieldElement eCFieldElement32 = f2m.zs[0];
                    boolean bl = eCFieldElement30.bitLength() == 1;
                    ECFieldElement eCFieldElement33 = eCFieldElement2;
                    ECFieldElement eCFieldElement34 = eCFieldElement31;
                    if (!bl) {
                        eCFieldElement33 = eCFieldElement33.multiply(eCFieldElement30);
                        eCFieldElement34 = eCFieldElement34.multiply(eCFieldElement30);
                    }
                    boolean bl2 = eCFieldElement32.bitLength() == 1;
                    ECFieldElement eCFieldElement35 = eCFieldElement;
                    ECFieldElement eCFieldElement36 = eCFieldElement29;
                    if (!bl2) {
                        eCFieldElement35 = eCFieldElement35.multiply(eCFieldElement32);
                        eCFieldElement36 = eCFieldElement36.multiply(eCFieldElement32);
                    }
                    ECFieldElement eCFieldElement37 = eCFieldElement36.add(eCFieldElement34);
                    ECFieldElement eCFieldElement38 = eCFieldElement35.add(eCFieldElement33);
                    if (eCFieldElement38.isZero()) {
                        if (eCFieldElement37.isZero()) {
                            return (F2m)this.twice();
                        }
                        return (F2m)eCCurve.getInfinity();
                    }
                    if (eCFieldElement2.isZero()) {
                        ECFieldElement eCFieldElement39 = this.getYCoord();
                        ECFieldElement eCFieldElement40 = eCFieldElement31;
                        ECFieldElement eCFieldElement41 = eCFieldElement39.add(eCFieldElement40).divide(eCFieldElement);
                        eCFieldElement28 = eCFieldElement41.square().add(eCFieldElement41).add(eCFieldElement).add(eCCurve.getA());
                        ECFieldElement eCFieldElement42 = eCFieldElement41.multiply(eCFieldElement.add(eCFieldElement28)).add(eCFieldElement28).add(eCFieldElement39);
                        eCFieldElement27 = eCFieldElement28.isZero() ? eCFieldElement42 : eCFieldElement42.divide(eCFieldElement28).add(eCFieldElement28);
                        eCFieldElement26 = eCCurve.fromBigInteger(ECConstants.ONE);
                    } else {
                        eCFieldElement38 = eCFieldElement38.square();
                        ECFieldElement eCFieldElement43 = eCFieldElement37.multiply(eCFieldElement35);
                        ECFieldElement eCFieldElement44 = eCFieldElement37.multiply(eCFieldElement33);
                        ECFieldElement eCFieldElement45 = eCFieldElement37.multiply(eCFieldElement38);
                        if (!bl2) {
                            eCFieldElement45 = eCFieldElement45.multiply(eCFieldElement32);
                        }
                        eCFieldElement28 = eCFieldElement43.multiply(eCFieldElement44);
                        eCFieldElement27 = eCFieldElement44.add(eCFieldElement38).square().add(eCFieldElement45.multiply(eCFieldElement29.add(eCFieldElement30)));
                        eCFieldElement26 = eCFieldElement45;
                        if (!bl) {
                            eCFieldElement26 = eCFieldElement26.multiply(eCFieldElement30);
                        }
                    }
                    return new F2m(eCCurve, eCFieldElement28, eCFieldElement27, new ECFieldElement[]{eCFieldElement26}, this.withCompression);
                }
            }
            throw new IllegalStateException("unsupported coordinate system");
        }

        public ECPoint subtract(ECPoint eCPoint) {
            F2m.checkPoints(this, eCPoint);
            return this.subtractSimple((F2m)eCPoint);
        }

        public F2m subtractSimple(F2m f2m) {
            if (f2m.isInfinity()) {
                return this;
            }
            return this.addSimple((F2m)f2m.negate());
        }

        public F2m tau() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve eCCurve = this.getCurve();
            int n = eCCurve.getCoordinateSystem();
            ECFieldElement eCFieldElement = this.x;
            switch (n) {
                case 0: 
                case 5: {
                    ECFieldElement eCFieldElement2 = this.y;
                    return new F2m(eCCurve, eCFieldElement.square(), eCFieldElement2.square(), this.withCompression);
                }
                case 1: 
                case 6: {
                    ECFieldElement eCFieldElement3 = this.y;
                    ECFieldElement eCFieldElement4 = this.zs[0];
                    return new F2m(eCCurve, eCFieldElement.square(), eCFieldElement3.square(), new ECFieldElement[]{eCFieldElement4.square()}, this.withCompression);
                }
            }
            throw new IllegalStateException("unsupported coordinate system");
        }

        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve eCCurve = this.getCurve();
            ECFieldElement eCFieldElement = this.x;
            if (eCFieldElement.isZero()) {
                return eCCurve.getInfinity();
            }
            int n = eCCurve.getCoordinateSystem();
            switch (n) {
                case 0: {
                    ECFieldElement eCFieldElement2 = this.y;
                    ECFieldElement eCFieldElement3 = eCFieldElement2.divide(eCFieldElement).add(eCFieldElement);
                    ECFieldElement eCFieldElement4 = eCFieldElement3.square().add(eCFieldElement3).add(eCCurve.getA());
                    ECFieldElement eCFieldElement5 = eCFieldElement.square().add(eCFieldElement4.multiply(eCFieldElement3.addOne()));
                    return new F2m(eCCurve, eCFieldElement4, eCFieldElement5, this.withCompression);
                }
                case 1: {
                    ECFieldElement eCFieldElement6 = this.y;
                    ECFieldElement eCFieldElement7 = this.zs[0];
                    boolean bl = eCFieldElement7.bitLength() == 1;
                    ECFieldElement eCFieldElement8 = bl ? eCFieldElement : eCFieldElement.multiply(eCFieldElement7);
                    ECFieldElement eCFieldElement9 = bl ? eCFieldElement6 : eCFieldElement6.multiply(eCFieldElement7);
                    ECFieldElement eCFieldElement10 = eCFieldElement.square();
                    ECFieldElement eCFieldElement11 = eCFieldElement10.add(eCFieldElement9);
                    ECFieldElement eCFieldElement12 = eCFieldElement8;
                    ECFieldElement eCFieldElement13 = eCFieldElement12.square();
                    ECFieldElement eCFieldElement14 = eCFieldElement11.square().add(eCFieldElement11.multiply(eCFieldElement12)).add(eCCurve.getA().multiply(eCFieldElement13));
                    ECFieldElement eCFieldElement15 = eCFieldElement12.multiply(eCFieldElement14);
                    ECFieldElement eCFieldElement16 = eCFieldElement14.multiply(eCFieldElement11.add(eCFieldElement12)).add(eCFieldElement10.square().multiply(eCFieldElement12));
                    ECFieldElement eCFieldElement17 = eCFieldElement12.multiply(eCFieldElement13);
                    return new F2m(eCCurve, eCFieldElement15, eCFieldElement16, new ECFieldElement[]{eCFieldElement17}, this.withCompression);
                }
                case 6: {
                    ECFieldElement eCFieldElement18;
                    ECFieldElement eCFieldElement19 = this.y;
                    ECFieldElement eCFieldElement20 = this.zs[0];
                    boolean bl = eCFieldElement20.bitLength() == 1;
                    ECFieldElement eCFieldElement21 = bl ? eCFieldElement19 : eCFieldElement19.multiply(eCFieldElement20);
                    ECFieldElement eCFieldElement22 = bl ? eCFieldElement20 : eCFieldElement20.square();
                    ECFieldElement eCFieldElement23 = eCCurve.getA();
                    ECFieldElement eCFieldElement24 = bl ? eCFieldElement23 : eCFieldElement23.multiply(eCFieldElement22);
                    ECFieldElement eCFieldElement25 = eCFieldElement19.square().add(eCFieldElement21).add(eCFieldElement24);
                    ECFieldElement eCFieldElement26 = eCFieldElement25.square();
                    ECFieldElement eCFieldElement27 = bl ? eCFieldElement25 : eCFieldElement25.multiply(eCFieldElement22);
                    ECFieldElement eCFieldElement28 = eCCurve.getB();
                    if (eCFieldElement28.bitLength() < eCCurve.getFieldSize() >> 1) {
                        ECFieldElement eCFieldElement29 = eCFieldElement19.add(eCFieldElement).square();
                        ECFieldElement eCFieldElement30 = eCFieldElement24.square();
                        ECFieldElement eCFieldElement31 = eCCurve.getB().multiply(eCFieldElement22.square());
                        eCFieldElement18 = eCFieldElement29.add(eCFieldElement25).add(eCFieldElement22).multiply(eCFieldElement29).add(eCFieldElement30.add(eCFieldElement31)).add(eCFieldElement26).add(eCFieldElement23.addOne().multiply(eCFieldElement27));
                    } else {
                        ECFieldElement eCFieldElement32 = bl ? eCFieldElement : eCFieldElement.multiply(eCFieldElement20);
                        eCFieldElement18 = eCFieldElement32.square().add(eCFieldElement26).add(eCFieldElement25.multiply(eCFieldElement21)).add(eCFieldElement27);
                    }
                    return new F2m(eCCurve, eCFieldElement26, eCFieldElement18, new ECFieldElement[]{eCFieldElement27}, this.withCompression);
                }
            }
            throw new IllegalStateException("unsupported coordinate system");
        }

        public ECPoint twicePlus(ECPoint eCPoint) {
            if (this.isInfinity()) {
                return eCPoint;
            }
            if (eCPoint.isInfinity()) {
                return this.twice();
            }
            ECCurve eCCurve = this.getCurve();
            ECFieldElement eCFieldElement = this.x;
            if (eCFieldElement.isZero()) {
                return eCPoint;
            }
            int n = eCCurve.getCoordinateSystem();
            switch (n) {
                case 6: {
                    ECFieldElement eCFieldElement2 = eCPoint.x;
                    ECFieldElement eCFieldElement3 = eCPoint.zs[0];
                    if (eCFieldElement2.isZero() || eCFieldElement3.bitLength() != 1) {
                        return this.twice().add(eCPoint);
                    }
                    ECFieldElement eCFieldElement4 = this.y;
                    ECFieldElement eCFieldElement5 = this.zs[0];
                    ECFieldElement eCFieldElement6 = eCPoint.y;
                    ECFieldElement eCFieldElement7 = eCFieldElement.square();
                    ECFieldElement eCFieldElement8 = eCFieldElement4.square();
                    ECFieldElement eCFieldElement9 = eCFieldElement5.square();
                    ECFieldElement eCFieldElement10 = eCFieldElement4.multiply(eCFieldElement5);
                    ECFieldElement eCFieldElement11 = eCCurve.getA().multiply(eCFieldElement9).add(eCFieldElement8).add(eCFieldElement10);
                    ECFieldElement eCFieldElement12 = eCFieldElement6.addOne();
                    ECFieldElement eCFieldElement13 = eCCurve.getA().add(eCFieldElement12).multiply(eCFieldElement9).add(eCFieldElement8).multiply(eCFieldElement11).add(eCFieldElement7.multiply(eCFieldElement9));
                    ECFieldElement eCFieldElement14 = eCFieldElement2.multiply(eCFieldElement9);
                    ECFieldElement eCFieldElement15 = eCFieldElement14.add(eCFieldElement11).square();
                    ECFieldElement eCFieldElement16 = eCFieldElement13.square().multiply(eCFieldElement14);
                    ECFieldElement eCFieldElement17 = eCFieldElement13.multiply(eCFieldElement15).multiply(eCFieldElement9);
                    ECFieldElement eCFieldElement18 = eCFieldElement13.add(eCFieldElement15).square().multiply(eCFieldElement11).add(eCFieldElement12.multiply(eCFieldElement17));
                    return new F2m(eCCurve, eCFieldElement16, eCFieldElement18, new ECFieldElement[]{eCFieldElement17}, this.withCompression);
                }
            }
            return this.twice().add(eCPoint);
        }

        protected void checkCurveEquation() {
            ECFieldElement eCFieldElement;
            ECFieldElement eCFieldElement2;
            if (this.isInfinity()) {
                return;
            }
            switch (this.getCurveCoordinateSystem()) {
                case 5: {
                    eCFieldElement2 = this.curve.fromBigInteger(ECConstants.ONE);
                    break;
                }
                case 6: {
                    eCFieldElement2 = this.zs[0];
                    break;
                }
                default: {
                    return;
                }
            }
            if (eCFieldElement2.isZero()) {
                throw new IllegalStateException();
            }
            ECFieldElement eCFieldElement3 = this.x;
            if (eCFieldElement3.isZero()) {
                ECFieldElement eCFieldElement4 = this.y;
                if (!eCFieldElement4.square().equals(this.curve.getB().multiply(eCFieldElement2))) {
                    throw new IllegalStateException();
                }
                return;
            }
            ECFieldElement eCFieldElement5 = this.y;
            ECFieldElement eCFieldElement6 = eCFieldElement3.square();
            ECFieldElement eCFieldElement7 = eCFieldElement2.square();
            ECFieldElement eCFieldElement8 = eCFieldElement5.square().add(eCFieldElement5.multiply(eCFieldElement2)).add(this.getCurve().getA().multiply(eCFieldElement7)).multiply(eCFieldElement6);
            if (!eCFieldElement8.equals(eCFieldElement = eCFieldElement7.square().multiply(this.getCurve().getB()).add(eCFieldElement6.square()))) {
                throw new IllegalStateException("F2m Lambda-Projective invariant broken");
            }
        }

        public ECPoint negate() {
            if (this.isInfinity()) {
                return this;
            }
            ECFieldElement eCFieldElement = this.x;
            if (eCFieldElement.isZero()) {
                return this;
            }
            switch (this.getCurveCoordinateSystem()) {
                case 0: {
                    ECFieldElement eCFieldElement2 = this.y;
                    return new F2m(this.curve, eCFieldElement, eCFieldElement2.add(eCFieldElement), this.withCompression);
                }
                case 1: {
                    ECFieldElement eCFieldElement3 = this.y;
                    ECFieldElement eCFieldElement4 = this.zs[0];
                    return new F2m(this.curve, eCFieldElement, eCFieldElement3.add(eCFieldElement), new ECFieldElement[]{eCFieldElement4}, this.withCompression);
                }
                case 5: {
                    ECFieldElement eCFieldElement5 = this.y;
                    return new F2m(this.curve, eCFieldElement, eCFieldElement5.addOne(), this.withCompression);
                }
                case 6: {
                    ECFieldElement eCFieldElement6 = this.y;
                    ECFieldElement eCFieldElement7 = this.zs[0];
                    return new F2m(this.curve, eCFieldElement, eCFieldElement6.add(eCFieldElement7), new ECFieldElement[]{eCFieldElement7}, this.withCompression);
                }
            }
            throw new IllegalStateException("unsupported coordinate system");
        }
    }

    public static class Fp
    extends ECPoint {
        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            this(eCCurve, eCFieldElement, eCFieldElement2, false);
        }

        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
            if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            this.withCompression = bl;
        }

        Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
            this.withCompression = bl;
        }

        protected boolean getCompressionYTilde() {
            return this.getAffineYCoord().testBitZero();
        }

        public ECFieldElement getZCoord(int n) {
            if (n == 1 && 4 == this.getCurveCoordinateSystem()) {
                return this.getJacobianModifiedW();
            }
            return super.getZCoord(n);
        }

        public ECPoint add(ECPoint eCPoint) {
            if (this.isInfinity()) {
                return eCPoint;
            }
            if (eCPoint.isInfinity()) {
                return this;
            }
            if (this == eCPoint) {
                return this.twice();
            }
            ECCurve eCCurve = this.getCurve();
            int n = eCCurve.getCoordinateSystem();
            ECFieldElement eCFieldElement = this.x;
            ECFieldElement eCFieldElement2 = this.y;
            ECFieldElement eCFieldElement3 = eCPoint.x;
            ECFieldElement eCFieldElement4 = eCPoint.y;
            switch (n) {
                case 0: {
                    ECFieldElement eCFieldElement5 = eCFieldElement3.subtract(eCFieldElement);
                    ECFieldElement eCFieldElement6 = eCFieldElement4.subtract(eCFieldElement2);
                    if (eCFieldElement5.isZero()) {
                        if (eCFieldElement6.isZero()) {
                            return this.twice();
                        }
                        return eCCurve.getInfinity();
                    }
                    ECFieldElement eCFieldElement7 = eCFieldElement6.divide(eCFieldElement5);
                    ECFieldElement eCFieldElement8 = eCFieldElement7.square().subtract(eCFieldElement).subtract(eCFieldElement3);
                    ECFieldElement eCFieldElement9 = eCFieldElement7.multiply(eCFieldElement.subtract(eCFieldElement8)).subtract(eCFieldElement2);
                    return new Fp(eCCurve, eCFieldElement8, eCFieldElement9, this.withCompression);
                }
                case 1: {
                    ECFieldElement eCFieldElement10 = this.zs[0];
                    ECFieldElement eCFieldElement11 = eCPoint.zs[0];
                    boolean bl = eCFieldElement10.bitLength() == 1;
                    boolean bl2 = eCFieldElement11.bitLength() == 1;
                    ECFieldElement eCFieldElement12 = bl ? eCFieldElement4 : eCFieldElement4.multiply(eCFieldElement10);
                    ECFieldElement eCFieldElement13 = bl2 ? eCFieldElement2 : eCFieldElement2.multiply(eCFieldElement11);
                    ECFieldElement eCFieldElement14 = eCFieldElement12.subtract(eCFieldElement13);
                    ECFieldElement eCFieldElement15 = bl ? eCFieldElement3 : eCFieldElement3.multiply(eCFieldElement10);
                    ECFieldElement eCFieldElement16 = bl2 ? eCFieldElement : eCFieldElement.multiply(eCFieldElement11);
                    ECFieldElement eCFieldElement17 = eCFieldElement15.subtract(eCFieldElement16);
                    if (eCFieldElement17.isZero()) {
                        if (eCFieldElement14.isZero()) {
                            return this.twice();
                        }
                        return eCCurve.getInfinity();
                    }
                    ECFieldElement eCFieldElement18 = bl ? eCFieldElement11 : (bl2 ? eCFieldElement10 : eCFieldElement10.multiply(eCFieldElement11));
                    ECFieldElement eCFieldElement19 = eCFieldElement17.square();
                    ECFieldElement eCFieldElement20 = eCFieldElement19.multiply(eCFieldElement17);
                    ECFieldElement eCFieldElement21 = eCFieldElement19.multiply(eCFieldElement16);
                    ECFieldElement eCFieldElement22 = eCFieldElement14.square().multiply(eCFieldElement18).subtract(eCFieldElement20).subtract(this.two(eCFieldElement21));
                    ECFieldElement eCFieldElement23 = eCFieldElement17.multiply(eCFieldElement22);
                    ECFieldElement eCFieldElement24 = eCFieldElement21.subtract(eCFieldElement22).multiply(eCFieldElement14).subtract(eCFieldElement20.multiply(eCFieldElement13));
                    ECFieldElement eCFieldElement25 = eCFieldElement20.multiply(eCFieldElement18);
                    return new Fp(eCCurve, eCFieldElement23, eCFieldElement24, new ECFieldElement[]{eCFieldElement25}, this.withCompression);
                }
                case 2: 
                case 4: {
                    Object object;
                    ECFieldElement eCFieldElement26;
                    ECFieldElement eCFieldElement27;
                    ECFieldElement eCFieldElement28;
                    ECFieldElement[] eCFieldElementArray;
                    ECFieldElement[] eCFieldElementArray2 = this.zs[0];
                    ECFieldElement eCFieldElement29 = eCPoint.zs[0];
                    boolean bl = eCFieldElementArray2.bitLength() == 1;
                    ECFieldElement eCFieldElement30 = null;
                    if (!bl && eCFieldElementArray2.equals(eCFieldElement29)) {
                        eCFieldElementArray = eCFieldElement.subtract(eCFieldElement3);
                        eCFieldElement28 = eCFieldElement2.subtract(eCFieldElement4);
                        if (eCFieldElementArray.isZero()) {
                            if (eCFieldElement28.isZero()) {
                                return this.twice();
                            }
                            return eCCurve.getInfinity();
                        }
                        ECFieldElement eCFieldElement31 = eCFieldElementArray.square();
                        ECFieldElement eCFieldElement32 = eCFieldElement.multiply(eCFieldElement31);
                        ECFieldElement eCFieldElement33 = eCFieldElement3.multiply(eCFieldElement31);
                        ECFieldElement eCFieldElement34 = eCFieldElement32.subtract(eCFieldElement33).multiply(eCFieldElement2);
                        eCFieldElement27 = eCFieldElement28.square().subtract(eCFieldElement32).subtract(eCFieldElement33);
                        eCFieldElement26 = eCFieldElement32.subtract(eCFieldElement27).multiply(eCFieldElement28).subtract(eCFieldElement34);
                        object = eCFieldElementArray;
                        if (bl) {
                            eCFieldElement30 = eCFieldElement31;
                        } else {
                            object = ((ECFieldElement)object).multiply((ECFieldElement)eCFieldElementArray2);
                        }
                    } else {
                        ECFieldElement eCFieldElement35;
                        ECFieldElement eCFieldElement36;
                        ECFieldElement eCFieldElement37;
                        boolean bl3;
                        ECFieldElement eCFieldElement38;
                        if (bl) {
                            eCFieldElementArray = eCFieldElementArray2;
                            eCFieldElement28 = eCFieldElement3;
                            eCFieldElement38 = eCFieldElement4;
                        } else {
                            eCFieldElementArray = eCFieldElementArray2.square();
                            eCFieldElement28 = eCFieldElementArray.multiply(eCFieldElement3);
                            ECFieldElement eCFieldElement39 = eCFieldElementArray.multiply((ECFieldElement)eCFieldElementArray2);
                            eCFieldElement38 = eCFieldElement39.multiply(eCFieldElement4);
                        }
                        boolean bl4 = bl3 = eCFieldElement29.bitLength() == 1;
                        if (bl3) {
                            ECFieldElement eCFieldElement40 = eCFieldElement29;
                            eCFieldElement37 = eCFieldElement;
                            eCFieldElement36 = eCFieldElement2;
                        } else {
                            ECFieldElement eCFieldElement41 = eCFieldElement29.square();
                            eCFieldElement37 = eCFieldElement41.multiply(eCFieldElement);
                            eCFieldElement35 = eCFieldElement41.multiply(eCFieldElement29);
                            eCFieldElement36 = eCFieldElement35.multiply(eCFieldElement2);
                        }
                        eCFieldElement35 = eCFieldElement37.subtract(eCFieldElement28);
                        ECFieldElement eCFieldElement42 = eCFieldElement36.subtract(eCFieldElement38);
                        if (eCFieldElement35.isZero()) {
                            if (eCFieldElement42.isZero()) {
                                return this.twice();
                            }
                            return eCCurve.getInfinity();
                        }
                        ECFieldElement eCFieldElement43 = eCFieldElement35.square();
                        ECFieldElement eCFieldElement44 = eCFieldElement43.multiply(eCFieldElement35);
                        ECFieldElement eCFieldElement45 = eCFieldElement43.multiply(eCFieldElement37);
                        eCFieldElement27 = eCFieldElement42.square().add(eCFieldElement44).subtract(this.two(eCFieldElement45));
                        eCFieldElement26 = eCFieldElement45.subtract(eCFieldElement27).multiply(eCFieldElement42).subtract(eCFieldElement36.multiply(eCFieldElement44));
                        object = eCFieldElement35;
                        if (!bl) {
                            object = ((ECFieldElement)object).multiply((ECFieldElement)eCFieldElementArray2);
                        }
                        if (!bl3) {
                            object = ((ECFieldElement)object).multiply(eCFieldElement29);
                        }
                        if (object == eCFieldElement35) {
                            eCFieldElement30 = eCFieldElement43;
                        }
                    }
                    if (n == 4) {
                        eCFieldElement28 = this.calculateJacobianModifiedW((ECFieldElement)object, eCFieldElement30);
                        eCFieldElementArray = new ECFieldElement[]{object, eCFieldElement28};
                    } else {
                        eCFieldElementArray = new ECFieldElement[]{object};
                    }
                    return new Fp(eCCurve, eCFieldElement27, eCFieldElement26, eCFieldElementArray, this.withCompression);
                }
            }
            throw new IllegalStateException("unsupported coordinate system");
        }

        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve eCCurve = this.getCurve();
            ECFieldElement eCFieldElement = this.y;
            if (eCFieldElement.isZero()) {
                return eCCurve.getInfinity();
            }
            int n = eCCurve.getCoordinateSystem();
            ECFieldElement eCFieldElement2 = this.x;
            switch (n) {
                case 0: {
                    ECFieldElement eCFieldElement3 = eCFieldElement2.square();
                    ECFieldElement eCFieldElement4 = this.three(eCFieldElement3).add(this.getCurve().getA()).divide(this.two(eCFieldElement));
                    ECFieldElement eCFieldElement5 = eCFieldElement4.square().subtract(this.two(eCFieldElement2));
                    ECFieldElement eCFieldElement6 = eCFieldElement4.multiply(eCFieldElement2.subtract(eCFieldElement5)).subtract(eCFieldElement);
                    return new Fp(eCCurve, eCFieldElement5, eCFieldElement6, this.withCompression);
                }
                case 1: {
                    ECFieldElement eCFieldElement7 = this.zs[0];
                    boolean bl = eCFieldElement7.bitLength() == 1;
                    ECFieldElement eCFieldElement8 = bl ? eCFieldElement7 : eCFieldElement7.square();
                    ECFieldElement eCFieldElement9 = eCCurve.getA();
                    if (!bl) {
                        eCFieldElement9 = eCFieldElement9.multiply(eCFieldElement8);
                    }
                    eCFieldElement9 = eCFieldElement9.add(this.three(eCFieldElement2.square()));
                    ECFieldElement eCFieldElement10 = bl ? eCFieldElement : eCFieldElement.multiply(eCFieldElement7);
                    ECFieldElement eCFieldElement11 = bl ? eCFieldElement.square() : eCFieldElement10.multiply(eCFieldElement);
                    ECFieldElement eCFieldElement12 = eCFieldElement2.multiply(eCFieldElement11);
                    ECFieldElement eCFieldElement13 = this.four(eCFieldElement12);
                    ECFieldElement eCFieldElement14 = eCFieldElement9.square().subtract(this.two(eCFieldElement13));
                    ECFieldElement eCFieldElement15 = this.two(eCFieldElement14.multiply(eCFieldElement10));
                    ECFieldElement eCFieldElement16 = eCFieldElement9.multiply(eCFieldElement13.subtract(eCFieldElement14)).subtract(this.two(this.two(eCFieldElement11).square()));
                    ECFieldElement eCFieldElement17 = bl ? this.four(eCFieldElement11) : this.two(eCFieldElement10).square();
                    ECFieldElement eCFieldElement18 = this.two(eCFieldElement17).multiply(eCFieldElement10);
                    return new Fp(eCCurve, eCFieldElement15, eCFieldElement16, new ECFieldElement[]{eCFieldElement18}, this.withCompression);
                }
                case 2: {
                    ECFieldElement eCFieldElement19;
                    ECFieldElement eCFieldElement20;
                    ECFieldElement eCFieldElement21;
                    ECFieldElement eCFieldElement22;
                    ECFieldElement eCFieldElement23 = this.zs[0];
                    boolean bl = eCFieldElement23.bitLength() == 1;
                    ECFieldElement eCFieldElement24 = bl ? eCFieldElement23 : eCFieldElement23.square();
                    ECFieldElement eCFieldElement25 = eCFieldElement.square();
                    ECFieldElement eCFieldElement26 = eCFieldElement25.square();
                    ECFieldElement eCFieldElement27 = eCCurve.getA();
                    ECFieldElement eCFieldElement28 = eCFieldElement27.negate();
                    if (eCFieldElement28.toBigInteger().equals(BigInteger.valueOf(3L))) {
                        eCFieldElement22 = this.three(eCFieldElement2.add(eCFieldElement24).multiply(eCFieldElement2.subtract(eCFieldElement24)));
                        eCFieldElement21 = this.four(eCFieldElement25.multiply(eCFieldElement2));
                    } else {
                        eCFieldElement20 = eCFieldElement2.square();
                        eCFieldElement22 = this.three(eCFieldElement20);
                        if (bl) {
                            eCFieldElement22 = eCFieldElement22.add(eCFieldElement27);
                        } else {
                            eCFieldElement19 = eCFieldElement24.square();
                            eCFieldElement22 = eCFieldElement28.bitLength() < eCFieldElement27.bitLength() ? eCFieldElement22.subtract(eCFieldElement19.multiply(eCFieldElement28)) : eCFieldElement22.add(eCFieldElement19.multiply(eCFieldElement27));
                        }
                        eCFieldElement21 = this.two(this.doubleProductFromSquares(eCFieldElement2, eCFieldElement25, eCFieldElement20, eCFieldElement26));
                    }
                    eCFieldElement20 = eCFieldElement22.square().subtract(this.two(eCFieldElement21));
                    eCFieldElement19 = eCFieldElement21.subtract(eCFieldElement20).multiply(eCFieldElement22).subtract(this.eight(eCFieldElement26));
                    ECFieldElement eCFieldElement29 = this.two(eCFieldElement);
                    if (!bl) {
                        eCFieldElement29 = eCFieldElement29.multiply(eCFieldElement23);
                    }
                    return new Fp(eCCurve, eCFieldElement20, eCFieldElement19, new ECFieldElement[]{eCFieldElement29}, this.withCompression);
                }
                case 4: {
                    return this.twiceJacobianModified(true);
                }
            }
            throw new IllegalStateException("unsupported coordinate system");
        }

        public ECPoint twicePlus(ECPoint eCPoint) {
            if (this == eCPoint) {
                return this.threeTimes();
            }
            if (this.isInfinity()) {
                return eCPoint;
            }
            if (eCPoint.isInfinity()) {
                return this.twice();
            }
            ECFieldElement eCFieldElement = this.y;
            if (eCFieldElement.isZero()) {
                return eCPoint;
            }
            ECCurve eCCurve = this.getCurve();
            int n = eCCurve.getCoordinateSystem();
            switch (n) {
                case 0: {
                    ECFieldElement eCFieldElement2 = this.x;
                    ECFieldElement eCFieldElement3 = eCPoint.x;
                    ECFieldElement eCFieldElement4 = eCPoint.y;
                    ECFieldElement eCFieldElement5 = eCFieldElement3.subtract(eCFieldElement2);
                    ECFieldElement eCFieldElement6 = eCFieldElement4.subtract(eCFieldElement);
                    if (eCFieldElement5.isZero()) {
                        if (eCFieldElement6.isZero()) {
                            return this.threeTimes();
                        }
                        return this;
                    }
                    ECFieldElement eCFieldElement7 = eCFieldElement5.square();
                    ECFieldElement eCFieldElement8 = eCFieldElement6.square();
                    ECFieldElement eCFieldElement9 = eCFieldElement7.multiply(this.two(eCFieldElement2).add(eCFieldElement3)).subtract(eCFieldElement8);
                    if (eCFieldElement9.isZero()) {
                        return eCCurve.getInfinity();
                    }
                    ECFieldElement eCFieldElement10 = eCFieldElement9.multiply(eCFieldElement5);
                    ECFieldElement eCFieldElement11 = eCFieldElement10.invert();
                    ECFieldElement eCFieldElement12 = eCFieldElement9.multiply(eCFieldElement11).multiply(eCFieldElement6);
                    ECFieldElement eCFieldElement13 = this.two(eCFieldElement).multiply(eCFieldElement7).multiply(eCFieldElement5).multiply(eCFieldElement11).subtract(eCFieldElement12);
                    ECFieldElement eCFieldElement14 = eCFieldElement13.subtract(eCFieldElement12).multiply(eCFieldElement12.add(eCFieldElement13)).add(eCFieldElement3);
                    ECFieldElement eCFieldElement15 = eCFieldElement2.subtract(eCFieldElement14).multiply(eCFieldElement13).subtract(eCFieldElement);
                    return new Fp(eCCurve, eCFieldElement14, eCFieldElement15, this.withCompression);
                }
                case 4: {
                    return this.twiceJacobianModified(false).add(eCPoint);
                }
            }
            return this.twice().add(eCPoint);
        }

        public ECPoint threeTimes() {
            if (this.isInfinity() || this.y.isZero()) {
                return this;
            }
            ECCurve eCCurve = this.getCurve();
            int n = eCCurve.getCoordinateSystem();
            switch (n) {
                case 0: {
                    ECFieldElement eCFieldElement = this.x;
                    ECFieldElement eCFieldElement2 = this.y;
                    ECFieldElement eCFieldElement3 = this.two(eCFieldElement2);
                    ECFieldElement eCFieldElement4 = eCFieldElement3.square();
                    ECFieldElement eCFieldElement5 = this.three(eCFieldElement.square()).add(this.getCurve().getA());
                    ECFieldElement eCFieldElement6 = eCFieldElement5.square();
                    ECFieldElement eCFieldElement7 = this.three(eCFieldElement).multiply(eCFieldElement4).subtract(eCFieldElement6);
                    if (eCFieldElement7.isZero()) {
                        return this.getCurve().getInfinity();
                    }
                    ECFieldElement eCFieldElement8 = eCFieldElement7.multiply(eCFieldElement3);
                    ECFieldElement eCFieldElement9 = eCFieldElement8.invert();
                    ECFieldElement eCFieldElement10 = eCFieldElement7.multiply(eCFieldElement9).multiply(eCFieldElement5);
                    ECFieldElement eCFieldElement11 = eCFieldElement4.square().multiply(eCFieldElement9).subtract(eCFieldElement10);
                    ECFieldElement eCFieldElement12 = eCFieldElement11.subtract(eCFieldElement10).multiply(eCFieldElement10.add(eCFieldElement11)).add(eCFieldElement);
                    ECFieldElement eCFieldElement13 = eCFieldElement.subtract(eCFieldElement12).multiply(eCFieldElement11).subtract(eCFieldElement2);
                    return new Fp(eCCurve, eCFieldElement12, eCFieldElement13, this.withCompression);
                }
                case 4: {
                    return this.twiceJacobianModified(false).add(this);
                }
            }
            return this.twice().add(this);
        }

        protected ECFieldElement two(ECFieldElement eCFieldElement) {
            return eCFieldElement.add(eCFieldElement);
        }

        protected ECFieldElement three(ECFieldElement eCFieldElement) {
            return this.two(eCFieldElement).add(eCFieldElement);
        }

        protected ECFieldElement four(ECFieldElement eCFieldElement) {
            return this.two(this.two(eCFieldElement));
        }

        protected ECFieldElement eight(ECFieldElement eCFieldElement) {
            return this.four(this.two(eCFieldElement));
        }

        protected ECFieldElement doubleProductFromSquares(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3, ECFieldElement eCFieldElement4) {
            return eCFieldElement.add(eCFieldElement2).square().subtract(eCFieldElement3).subtract(eCFieldElement4);
        }

        public ECPoint subtract(ECPoint eCPoint) {
            if (eCPoint.isInfinity()) {
                return this;
            }
            return this.add(eCPoint.negate());
        }

        public ECPoint negate() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve eCCurve = this.getCurve();
            int n = eCCurve.getCoordinateSystem();
            if (0 != n) {
                return new Fp(eCCurve, this.x, this.y.negate(), this.zs, this.withCompression);
            }
            return new Fp(eCCurve, this.x, this.y.negate(), this.withCompression);
        }

        protected ECFieldElement calculateJacobianModifiedW(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            if (eCFieldElement2 == null) {
                eCFieldElement2 = eCFieldElement.square();
            }
            ECFieldElement eCFieldElement3 = eCFieldElement2.square();
            ECFieldElement eCFieldElement4 = this.getCurve().getA();
            ECFieldElement eCFieldElement5 = eCFieldElement4.negate();
            eCFieldElement3 = eCFieldElement5.bitLength() < eCFieldElement4.bitLength() ? eCFieldElement3.multiply(eCFieldElement5).negate() : eCFieldElement3.multiply(eCFieldElement4);
            return eCFieldElement3;
        }

        protected ECFieldElement getJacobianModifiedW() {
            ECFieldElement eCFieldElement = this.zs[1];
            if (eCFieldElement == null) {
                this.zs[1] = eCFieldElement = this.calculateJacobianModifiedW(this.zs[0], null);
            }
            return eCFieldElement;
        }

        protected Fp twiceJacobianModified(boolean bl) {
            ECFieldElement eCFieldElement = this.x;
            ECFieldElement eCFieldElement2 = this.y;
            ECFieldElement eCFieldElement3 = this.zs[0];
            ECFieldElement eCFieldElement4 = this.getJacobianModifiedW();
            ECFieldElement eCFieldElement5 = eCFieldElement.square();
            ECFieldElement eCFieldElement6 = this.three(eCFieldElement5).add(eCFieldElement4);
            ECFieldElement eCFieldElement7 = eCFieldElement2.square();
            ECFieldElement eCFieldElement8 = eCFieldElement7.square();
            ECFieldElement eCFieldElement9 = this.two(this.doubleProductFromSquares(eCFieldElement, eCFieldElement7, eCFieldElement5, eCFieldElement8));
            ECFieldElement eCFieldElement10 = eCFieldElement6.square().subtract(this.two(eCFieldElement9));
            ECFieldElement eCFieldElement11 = this.eight(eCFieldElement8);
            ECFieldElement eCFieldElement12 = eCFieldElement6.multiply(eCFieldElement9.subtract(eCFieldElement10)).subtract(eCFieldElement11);
            ECFieldElement eCFieldElement13 = bl ? this.two(eCFieldElement11.multiply(eCFieldElement4)) : null;
            ECFieldElement eCFieldElement14 = this.two(eCFieldElement3.bitLength() == 1 ? eCFieldElement2 : eCFieldElement2.multiply(eCFieldElement3));
            return new Fp(this.getCurve(), eCFieldElement10, eCFieldElement12, new ECFieldElement[]{eCFieldElement14, eCFieldElement13}, this.withCompression);
        }
    }
}

