/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import org.vafer.jdeb.utils.Utils;

public class InformationOutputStream
extends DigestOutputStream {
    private final MessageDigest digest;
    private long size;

    public InformationOutputStream(OutputStream pStream, MessageDigest pDigest) {
        super(pStream, pDigest);
        this.digest = pDigest;
        this.size = 0L;
    }

    public String getHexDigest() {
        return Utils.toHex(this.digest.digest());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.size += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++this.size;
    }

    public long getSize() {
        return this.size;
    }
}

