/*
 * Decompiled with CFR 0.152.
 */
import com.avaje.ebean.Ebean;
import com.typesafe.config.ConfigFactory;
import fileauth.FileAuthScanJob;
import java.util.Collection;
import java.util.Map;
import jobs.DnsUpdateJob;
import models.Domain;
import org.yaml.snakeyaml.error.YAMLException;
import play.Application;
import play.GlobalSettings;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Yaml;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Global
extends GlobalSettings {
    private static final String AUTODNS_NS_1 = ConfigFactory.load().getString("autodns.ns1");
    private static final String AUTODNS_NS_2 = ConfigFactory.load().getString("autodns.ns2");
    private static final String AUTODNS_NS_3 = ConfigFactory.load().getString("autodns.ns3");
    private static final String AUTODNS_NS_4 = ConfigFactory.load().getString("autodns.ns4");

    public void onStart(Application app) {
        InitialData.insert(app);
        Logger.info((String)("@" + System.currentTimeMillis() + " Application has started"));
        FileAuthScanJob.schedule();
        DnsUpdateJob.schedule();
    }

    public void onStop(Application app) {
        Logger.info((String)("@" + System.currentTimeMillis() + " Application shutdown..."));
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    static class InitialData {
        InitialData() {
        }

        public static void insert(Application app) {
            try {
                Logger.info((String)("@" + System.currentTimeMillis() + " InitialData..."));
                if (Ebean.find(Domain.class).findRowCount() == 0) {
                    Map all = (Map)Yaml.load((String)"initial-data.yml");
                    Ebean.save((Collection)((Collection)all.get("domains")));
                    Ebean.save((Collection)((Collection)all.get("subdomains")));
                    for (Domain domain : Domain.Find.all()) {
                        domain.setNameservers(AUTODNS_NS_1, AUTODNS_NS_2, AUTODNS_NS_3, AUTODNS_NS_4);
                        domain.save();
                    }
                }
                Logger.info((String)("@" + System.currentTimeMillis() + " InitialData done."));
            }
            catch (YAMLException ex) {
                Logger.warn((String)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }
}

