/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.routes;
import fileauth.actions.BasicAuth;
import helpers.DnsInquireHelper;
import helpers.DnsUpdateHelper;
import java.util.List;
import jobs.DnsInquireJob;
import models.Account;
import models.Domain;
import models.ResourceRecord;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import views.html.AdminDomains.index;
import views.html.AdminDomains.show;

@BasicAuth
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AdminDomains
extends Controller {
    static final Form<Domain> DOMAIN_FORM = Form.form(Domain.class);

    public static Result index() {
        Account account = Account.geAccountOrCreate(AdminDomains.request().username());
        if (!account.isAdmin()) {
            return AdminDomains.forbidden();
        }
        List domains = Domain.Find.order("name ASC").findList();
        return AdminDomains.ok((Content)index.render(domains, DOMAIN_FORM));
    }

    public static Result show(String name) {
        if (name == null || name.isEmpty()) {
            return AdminDomains.notFound();
        }
        Account account = Account.geAccountOrCreate(AdminDomains.request().username());
        if (!account.isAdmin()) {
            return AdminDomains.forbidden();
        }
        Domain domain = (Domain)((Object)Domain.Find.where().eq("name", (Object)name).findUnique());
        if (domain == null) {
            return AdminDomains.notFound();
        }
        return AdminDomains.ok((Content)show.render(domain, ResourceRecord.RECORD_FORM));
    }

    public static Result save() {
        Account account = Account.geAccountOrCreate(AdminDomains.request().username());
        if (!account.isAdmin()) {
            return AdminDomains.forbidden();
        }
        Form domainForm = DOMAIN_FORM.bindFromRequest(new String[0]);
        if (domainForm.hasErrors()) {
            List domains = Domain.Find.all();
            return AdminDomains.ok((Content)index.render(domains, (Form<Domain>)domainForm));
        }
        Domain domain = (Domain)((Object)domainForm.get());
        if (domain != null && !Domain.exists(domain) && domain.checkName()) {
            domain.save();
        }
        new DnsUpdateHelper(domain).update();
        new DnsInquireHelper(domain).inquire();
        return AdminDomains.redirect((Call)routes.AdminDomains.index());
    }

    public static Result inquire(String name) {
        if (name == null || name.isEmpty()) {
            return AdminDomains.notFound();
        }
        Account account = Account.geAccountOrCreate(AdminDomains.request().username());
        if (!account.isAdmin()) {
            return AdminDomains.forbidden();
        }
        Domain domain = (Domain)((Object)Domain.Find.where().eq("name", (Object)name).findUnique());
        if (domain != null) {
            DnsInquireJob job = new DnsInquireJob(domain);
            job.run();
        }
        return AdminDomains.redirect((Call)routes.AdminDomains.index());
    }
}

