/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Application;
import controllers.routes;
import fileauth.actions.BasicAuth;
import java.util.Date;
import java.util.List;
import jobs.DnsUpdateJob;
import jobs.MaintenanceJob;
import models.Account;
import models.DnsEntry;
import models.Domain;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Model;
import play.mvc.Call;
import play.mvc.Result;
import play.twirl.api.Content;
import views.html.AdminDynDNS.index;

@BasicAuth
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AdminDynDNS
extends Application {
    public static Result index() {
        Account account = Account.geAccountOrCreate(AdminDynDNS.request().username());
        if (!account.isAdmin()) {
            return AdminDynDNS.forbidden();
        }
        List entries = DnsEntry.Find.order("name ASC").findList();
        List accounts = Account.Find.order("username ASC").findList();
        return AdminDynDNS.ok((Content)index.render(entries, accounts));
    }

    public static Result update(Long id) {
        Account account = Account.geAccountOrCreate(AdminDynDNS.request().username());
        if (!account.isAdmin()) {
            return AdminDynDNS.forbidden();
        }
        Form entryForm = Form.form(DnsEntry.class).bindFromRequest(new String[0]);
        DnsEntry entry = (DnsEntry)((Object)entryForm.get());
        DnsEntry oldEntry = (DnsEntry)((Object)DnsEntry.Find.byId((Object)id));
        String string = null;
        DnsEntry dnsEntry = entry;
        dnsEntry.setUpdated((Date)((Object)string));
        dnsEntry = oldEntry;
        string = null;
        string = dnsEntry.getApiKey();
        dnsEntry = entry;
        dnsEntry.setApiKey(string);
        entry.update(id);
        return AdminDynDNS.redirect((Call)routes.AdminDynDNS.index());
    }

    public static Result startJob(String jobName) {
        Runnable job;
        Account account = Account.geAccountOrCreate(AdminDynDNS.request().username());
        if (!account.isAdmin()) {
            return AdminDynDNS.forbidden();
        }
        if ("DnsUpdate".equals(jobName)) {
            job = new DnsUpdateJob();
            ((DnsUpdateJob)job).run();
        }
        if ("Maintenance".equals(jobName)) {
            job = new MaintenanceJob();
            ((MaintenanceJob)job).run();
        }
        return AdminDynDNS.redirect((Call)routes.AdminDynDNS.index());
    }

    public static Result delete(Long id) {
        Account account = Account.geAccountOrCreate(AdminDynDNS.request().username());
        if (!account.isAdmin()) {
            return AdminDynDNS.forbidden();
        }
        DnsEntry entry = (DnsEntry)((Object)DnsEntry.Find.byId((Object)id));
        if (entry != null) {
            Model model = entry;
            Object object = null;
            object = model.getDomain();
            model = object;
            object = null;
            object = model.getId();
            Domain domain = (Domain)((Object)Domain.Find.byId(object));
            entry.delete();
            object = true;
            model = domain;
            model.setForceUpdate((Boolean)object);
            domain.save();
        }
        return AdminDynDNS.redirect((Call)routes.AdminDynDNS.index());
    }

    public static Result resetApiKey(Long id) {
        Account account = Account.geAccountOrCreate(AdminDynDNS.request().username());
        if (!account.isAdmin()) {
            return AdminDynDNS.forbidden();
        }
        DnsEntry entry = (DnsEntry)((Object)DnsEntry.Find.byId((Object)id));
        if (entry != null) {
            String string = DnsEntry.generateApiKey();
            DnsEntry dnsEntry = entry;
            dnsEntry.setApiKey(string);
            entry.update();
        }
        return AdminDynDNS.redirect((Call)routes.AdminDynDNS.index());
    }
}

