/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Application;
import controllers.routes;
import fileauth.actions.BasicAuth;
import helpers.DnsInquireHelper;
import helpers.DnsUpdateHelper;
import models.Account;
import models.Domain;
import models.ResourceRecord;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Model;
import play.mvc.Call;
import play.mvc.Result;
import play.twirl.api.Content;
import views.html.AdminDomains.show;
import views.html.AdminResourceRecords.edit;

@BasicAuth
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AdminResourceRecords
extends Application {
    public static Result save(String name) {
        if (name == null || name.isEmpty()) {
            return AdminResourceRecords.notFound();
        }
        Account account = Account.geAccountOrCreate(AdminResourceRecords.request().username());
        if (!account.isAdmin()) {
            return AdminResourceRecords.forbidden();
        }
        Domain domain = (Domain)((Object)Domain.Find.where().eq("name", (Object)name).findUnique());
        if (domain == null) {
            return AdminResourceRecords.notFound();
        }
        Form resourceForm = ResourceRecord.RECORD_FORM.bindFromRequest(new String[0]);
        Logger.debug((String)("form-data: " + resourceForm.data()));
        if (resourceForm.hasErrors()) {
            return AdminResourceRecords.ok((Content)show.render(domain, (Form<ResourceRecord>)resourceForm));
        }
        ResourceRecord rr = (ResourceRecord)((Object)resourceForm.get());
        Object object = domain;
        Model model = rr;
        model.setDomain((Domain)((Object)object));
        if (rr.ttl == null) {
            object = 3600;
            model = rr;
            model.setTtl((Integer)object);
        }
        Logger.debug((String)("got: " + rr.toString()));
        model = rr;
        object = null;
        object = model.getId();
        if (object != null) {
            rr.update();
        } else {
            rr.save();
        }
        object = true;
        model = domain;
        model.setForceUpdate((Boolean)object);
        domain.save();
        new DnsUpdateHelper(domain).update();
        new DnsInquireHelper(domain).inquire();
        model = domain;
        object = null;
        object = model.getName();
        return AdminResourceRecords.redirect((Call)routes.AdminDomains.show((String)object));
    }

    public static Result edit(String name, Long id) {
        if (name == null || name.isEmpty()) {
            return AdminResourceRecords.notFound();
        }
        Account account = Account.geAccountOrCreate(AdminResourceRecords.request().username());
        if (!account.isAdmin()) {
            return AdminResourceRecords.forbidden();
        }
        Domain domain = (Domain)((Object)Domain.Find.where().eq("name", (Object)name).findUnique());
        if (domain == null) {
            return AdminResourceRecords.notFound();
        }
        ResourceRecord rr = (ResourceRecord)((Object)ResourceRecord.Find.byId((Object)id));
        return AdminResourceRecords.ok((Content)edit.render(domain, rr, ResourceRecord.RECORD_FORM));
    }

    public static Result delete(String name, Long id) {
        Domain domain;
        Object object;
        if (name == null || name.isEmpty()) {
            return AdminResourceRecords.notFound();
        }
        Account account = Account.geAccountOrCreate(AdminResourceRecords.request().username());
        if (!account.isAdmin()) {
            return AdminResourceRecords.forbidden();
        }
        Domain domain2 = (Domain)((Object)Domain.Find.where().eq("name", (Object)name).findUnique());
        if (domain2 == null) {
            return AdminResourceRecords.notFound();
        }
        ResourceRecord rr = (ResourceRecord)((Object)ResourceRecord.Find.byId((Object)id));
        if (rr != null) {
            rr.delete();
            Logger.info((String)("rr " + rr.toString() + " #" + id + " was deleted!"));
            object = true;
            domain = domain2;
            domain.setForceUpdate((Boolean)object);
            domain2.save();
        }
        domain = domain2;
        object = null;
        object = domain.getName();
        return AdminResourceRecords.redirect((Call)routes.AdminDomains.show((String)object));
    }
}

