/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.kenshoo.play.metrics.MetricsRegistry;
import models.DnsEntry;
import models.Ip;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Controller;
import play.mvc.Result;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DnsUpdate
extends Controller {
    private static final String USER_AGENT = "User-Agent";

    public static Result updateIp(String k, String ip) {
        DnsEntry entry = (DnsEntry)((Object)DnsEntry.Find.where().eq("apiKey", (Object)k.trim()).findUnique());
        Logger.info((String)("update for " + (Object)((Object)entry) + " by " + DnsUpdate.getAgent()));
        if (ip == null) {
            ip = DnsUpdate.getIp();
        }
        if (Ip.valid(ip) && entry != null) {
            entry.update(ip, k);
            DnsEntry dnsEntry = entry;
            String string = null;
            string = dnsEntry.getActualIp();
            if (string != null) {
                dnsEntry = entry;
                string = null;
                string = dnsEntry.getActualIp();
                if (string.equals(ip)) {
                    MetricsRegistry.defaultRegistry().meter("DnsUpdate-nochg-ip4").mark();
                    return DnsUpdate.ok((String)("nochg " + ip));
                }
            }
            dnsEntry = entry;
            string = null;
            string = dnsEntry.getActualIp6();
            if (string != null) {
                dnsEntry = entry;
                string = null;
                string = dnsEntry.getActualIp6();
                if (string.equals(ip)) {
                    MetricsRegistry.defaultRegistry().meter("DnsUpdate-nochg-ip6").mark();
                    return DnsUpdate.ok((String)("nochg " + ip));
                }
            }
            MetricsRegistry.defaultRegistry().meter("DnsUpdate-good").mark();
            return DnsUpdate.ok((String)("good " + ip));
        }
        return DnsUpdate.badRequest((String)"nohost");
    }

    public static Result update(String k) {
        return DnsUpdate.updateIp(k, null);
    }

    private static String getAgent() {
        return DnsUpdate.request().hasHeader(USER_AGENT) ? DnsUpdate.request().getHeader(USER_AGENT) : "N/A";
    }

    private static String getIp() {
        StringBuilder sb = new StringBuilder();
        for (String key : DnsUpdate.request().headers().keySet()) {
            if (key.equals("Authorization")) continue;
            sb.append(key).append(" = ").append(DnsUpdate.request().getHeader(key)).append("\n");
        }
        Logger.info((String)("headers:\n" + sb.toString()));
        String ip = DnsUpdate.request().getQueryString("ip") != null ? DnsUpdate.request().getQueryString("ip") : (DnsUpdate.request().getHeader("X-Forwarded-For") != null ? DnsUpdate.request().getHeader("X-Forwarded-For") : DnsUpdate.request().remoteAddress());
        return ip;
    }
}

