/*
 * Decompiled with CFR 0.152.
 */
package fileauth;

import com.typesafe.config.ConfigFactory;
import fileauth.utils.MD5Crypt;
import fileauth.utils.UnixCrypt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import play.Logger;
import play.cache.Cache;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class FileAuth {
    public static final String AUTH_FILE_USERS_CACHE_KEY = "AUTH_FILE_USERS";
    public static final String AUTH_FILE_GROUPS_CACHE_KEY = "AUTH_FILE_GROUPS";
    private static final int CACHE_TIMEOUT = 300;
    private static final boolean IS_ENABLED = FileAuth.isEnabled();
    private static final String AUTH_FILE_USERS_DELIMETER = FileAuth.getConfig("authfile.users.delimeter", ":");
    private static final String AUTH_FILE_GROUPS_DELIMETER = FileAuth.getConfig("authfile.groups.delimeter", " ");
    private static final String AUTH_FILE_USERS_PATH = ConfigFactory.load().getString("authfile.users.path");
    private static final String AUTH_FILE_GROUPS_PATH = ConfigFactory.load().getString("authfile.groups.path");

    public static Map<String, String> getUsers() {
        if (!IS_ENABLED) {
            return new HashMap<String, String>();
        }
        Map<Object, Object> users = (HashMap)Cache.get((String)AUTH_FILE_USERS_CACHE_KEY);
        if (users == null) {
            users = FileAuth.scanUsers();
        }
        return users;
    }

    public static Map<String, Set<String>> getGroups() {
        if (!IS_ENABLED) {
            return new HashMap<String, Set<String>>();
        }
        Map<Object, Object> groups = (HashMap)Cache.get((String)AUTH_FILE_GROUPS_CACHE_KEY);
        if (groups == null) {
            groups = FileAuth.scanGroups();
        }
        return groups;
    }

    public static boolean contains(String group, String user) {
        if (!IS_ENABLED) {
            return false;
        }
        if (group == null || user == null) {
            return false;
        }
        Map<String, Set<String>> groups = FileAuth.getGroups();
        Set<String> groupUsers = groups.get(group);
        if (groupUsers == null) {
            return false;
        }
        return groupUsers.contains(user);
    }

    public static boolean validate(String user, String password) {
        if (!IS_ENABLED) {
            return false;
        }
        if (user == null || password == null) {
            return false;
        }
        Map<String, String> users = FileAuth.getUsers();
        String encryptedPass = users.get(user);
        if (encryptedPass == null) {
            Logger.warn((String)("encryptedPass is NULL for user " + user));
            return false;
        }
        if (encryptedPass.startsWith("$") && MD5Crypt.verifyPassword(password, encryptedPass)) {
            return true;
        }
        if (encryptedPass.length() == 13 && UnixCrypt.matches(encryptedPass, password)) {
            return true;
        }
        Logger.warn((String)("could not validate user " + user));
        return false;
    }

    public static Map<String, String> scanUsers() {
        String fileName = AUTH_FILE_USERS_PATH;
        StringBuilder sb = new StringBuilder("@" + System.currentTimeMillis() + " Scanning Users in " + fileName + "... ");
        HashMap<String, String> users = new HashMap<String, String>();
        File file = new File(fileName);
        if (file == null || !file.exists() || !file.isFile()) {
            Logger.warn((String)(fileName + " is not a valid Auth-File!"));
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String[] parts = line.split(AUTH_FILE_USERS_DELIMETER);
                if (parts.length <= 1) continue;
                users.put(parts[0].trim(), parts[1].trim());
            }
            br.close();
            Cache.set((String)AUTH_FILE_USERS_CACHE_KEY, users, (int)300);
        }
        catch (FileNotFoundException ex) {
            Logger.error((String)ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            Logger.error((String)ex.getLocalizedMessage(), (Throwable)ex);
        }
        sb.append(" found " + users.size() + " mappings");
        Logger.info((String)sb.toString());
        return users;
    }

    public static Map<String, Set<String>> scanGroups() {
        String fileName = AUTH_FILE_GROUPS_PATH;
        StringBuilder sb = new StringBuilder("@" + System.currentTimeMillis() + " Scanning Groups in " + fileName + "... ");
        HashMap<String, Set<String>> groups = new HashMap<String, Set<String>>();
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            Logger.warn((String)(fileName + " is not a valid Auth-File!"));
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String[] userParts;
                String[] parts = line.split(AUTH_FILE_USERS_DELIMETER);
                if (parts.length <= 1 || (userParts = parts.length > 2 ? parts[parts.length - 1].split(AUTH_FILE_GROUPS_DELIMETER) : parts[1].split(AUTH_FILE_GROUPS_DELIMETER)).length <= 0) continue;
                HashSet<String> users = new HashSet<String>();
                for (String user : userParts) {
                    users.add(user.trim());
                }
                groups.put(parts[0].trim(), users);
            }
            br.close();
            Cache.set((String)AUTH_FILE_GROUPS_CACHE_KEY, groups, (int)300);
        }
        catch (FileNotFoundException ex) {
            Logger.error((String)ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            Logger.error((String)ex.getLocalizedMessage(), (Throwable)ex);
        }
        sb.append(" found " + groups.size() + " mappings");
        Logger.info((String)sb.toString());
        return groups;
    }

    private static boolean isEnabled() {
        if (!ConfigFactory.load().hasPath("authfile.users.path") || !ConfigFactory.load().hasPath("authfile.groups.path")) {
            Logger.info((String)"FileAuth not enabled. authfile.users.path or authfile.groups.path not set!");
            return false;
        }
        return true;
    }

    private static String getConfig(String key, String defaultValue) {
        if (ConfigFactory.load().hasPath(key)) {
            return ConfigFactory.load().getString(key);
        }
        Logger.info((String)("@" + System.currentTimeMillis() + " Config " + key + " not found, using default: '" + defaultValue + "'"));
        return defaultValue;
    }
}

