/*
 * Decompiled with CFR 0.152.
 */
package fileauth.actions;

import com.ning.http.util.Base64;
import com.typesafe.config.ConfigFactory;
import models.Account;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class BasicAuthAction
extends Action<Object> {
    private static final String AUTHORIZATION = "authorization";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String REALM = BasicAuthAction.getRealm();

    public F.Promise<Result> call(Http.Context context) throws Throwable {
        String authHeader = context.request().getHeader(AUTHORIZATION);
        if (authHeader == null) {
            return this.sendAuthRequest(context);
        }
        String auth = authHeader.substring(6);
        byte[] decodedAuth = Base64.decode((String)auth);
        String[] credString = new String(decodedAuth, "UTF-8").split(":");
        if (credString == null || credString.length != 2) {
            return this.sendAuthRequest(context);
        }
        String username = credString[0];
        String password = credString[1];
        Account authUser = Account.authenticate(username, password);
        if (authUser == null) {
            return this.sendAuthRequest(context);
        }
        context.request().setUsername(username);
        return this.delegate.call(context);
    }

    private F.Promise<Result> sendAuthRequest(Http.Context context) {
        context.response().setHeader(WWW_AUTHENTICATE, REALM);
        return F.Promise.pure((Object)BasicAuthAction.unauthorized());
    }

    private static String getRealm() {
        if (ConfigFactory.load().hasPath("app.name")) {
            return "Basic realm=\"" + ConfigFactory.load().getString("app.name") + "\"";
        }
        return "Basic realm=\"NA\"";
    }
}

