/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import com.typesafe.config.ConfigFactory;
import java.util.ArrayList;
import java.util.List;
import models.Domain;
import models.Ip;
import models.ResourceRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DnsInquireHelper {
    private static final String AUTODNS_HOST = ConfigFactory.load().getString("autodns.host");
    private static final String AUTODNS_USERNAME = ConfigFactory.load().getString("autodns.user");
    private static final String AUTODNS_PASSWORD = ConfigFactory.load().getString("autodns.pass");
    private static final String AUTODNS_CONTEXT = ConfigFactory.load().getString("autodns.context");
    private static final String AUTODNS_NS_1 = ConfigFactory.load().getString("autodns.ns1");
    private Domain domain;

    public DnsInquireHelper(Domain domain) {
        this.domain = domain;
    }

    public void inquire() {
        String message = this.getRequest();
        Domain domain = this.domain;
        String string = null;
        string = domain.getName();
        Logger.debug((String)("@" + System.currentTimeMillis() + " sending Inquire for " + string + ":\n" + message + "\n"));
        this.performInquire(message);
    }

    private String getRequest() {
        Domain domain = this.domain;
        String string = null;
        string = domain.getName();
        return "<request><auth><user>" + AUTODNS_USERNAME + "</user><password>" + AUTODNS_PASSWORD + "</password><context>" + AUTODNS_CONTEXT + "</context></auth><task><code>0205</code><zone><system_ns>" + AUTODNS_NS_1 + "</system_ns><name>" + string + "</name></zone><key></key></task></request>";
    }

    private void performInquire(String content) {
        F.Promise xmlPromise = WS.url((String)AUTODNS_HOST).setHeader("Content-Type", "text/xml; charset=utf-8").post(content).map((F.Function)new F.Function<WSResponse, Document>(){

            public Document apply(WSResponse response) {
                Logger.debug((String)("response: " + response.getBody()));
                Document doc = response.asXml();
                if (DnsInquireHelper.this.getUpdateStatus(doc)) {
                    Domain domain = DnsInquireHelper.this.domain;
                    String string = null;
                    string = domain.getName();
                    Logger.info((String)("@" + System.currentTimeMillis() + " inquire " + string + " success!"));
                    DnsInquireHelper.this.domain = DnsInquireHelper.updatingDomain(doc, DnsInquireHelper.this.domain);
                    DnsInquireHelper.this.domain.save();
                } else {
                    Domain domain = DnsInquireHelper.this.domain;
                    String string = null;
                    string = domain.getName();
                    Logger.error((String)("@" + System.currentTimeMillis() + " inquire " + string + " error:\n"), (Object[])new Object[]{doc.getTextContent()});
                }
                return doc;
            }
        });
    }

    private static Domain updatingDomain(Document doc, Domain domain) {
        List<ResourceRecord> oldResourceRecords = domain.getResourceRecords();
        ArrayList<ResourceRecord> newResourceRecords = new ArrayList<ResourceRecord>();
        domain = DnsInquireHelper.updatingMain(doc, domain);
        domain = DnsInquireHelper.updatingSoa(doc, domain);
        domain = DnsInquireHelper.updatingNS(doc, domain);
        NodeList rrList = doc.getElementsByTagName("rr");
        for (int i = 0; i < rrList.getLength(); ++i) {
            Node n = rrList.item(i);
            newResourceRecords.add(DnsInquireHelper.getRRFromNode(n, domain));
        }
        DnsInquireHelper.cleanResourceRecords(oldResourceRecords, newResourceRecords);
        return domain;
    }

    private static void cleanResourceRecords(List<ResourceRecord> oldResourceRecords, List<ResourceRecord> newResourceRecords) {
        for (ResourceRecord rr : oldResourceRecords) {
            if (newResourceRecords.contains((Object)rr)) continue;
            Logger.debug((String)("removing RR: " + rr.name));
            ResourceRecord resourceRecord = rr;
            Long l = null;
            l = resourceRecord.getId();
            ((ResourceRecord)((Object)ResourceRecord.Find.byId((Object)l))).delete();
        }
    }

    private static Domain updatingMain(Document doc, Domain domain) {
        NodeList zoneList = doc.getElementsByTagName("zone");
        if (zoneList.getLength() == 1) {
            NodeList elements = zoneList.item(0).getChildNodes();
            block6: for (int i = 0; i < elements.getLength(); ++i) {
                switch (elements.item(i).getNodeName().toLowerCase()) {
                    case "main": {
                        Node n = elements.item(i);
                        for (int j = 0; j < n.getChildNodes().getLength(); ++j) {
                            if (!"value".equals(n.getChildNodes().item(j).getNodeName())) continue;
                            String string = n.getChildNodes().item(0).getTextContent();
                            Domain domain2 = domain;
                            domain2.setIp(string);
                        }
                        continue block6;
                    }
                }
            }
        }
        return domain;
    }

    private static Domain updatingSoa(Document doc, Domain domain) {
        NodeList soaList = doc.getElementsByTagName("soa");
        if (soaList.getLength() > 0) {
            Node soa = soaList.item(0);
            NodeList elements = soa.getChildNodes();
            block16: for (int j = 0; j < elements.getLength(); ++j) {
                switch (elements.item(j).getNodeName().toLowerCase()) {
                    case "refresh": {
                        Object object = DnsInquireHelper.getInteger(elements.item(j).getTextContent());
                        Domain domain2 = domain;
                        domain2.setSoaRefresh((Integer)object);
                        continue block16;
                    }
                    case "retry": {
                        Object object = DnsInquireHelper.getInteger(elements.item(j).getTextContent());
                        Domain domain2 = domain;
                        domain2.setSoaRetry((Integer)object);
                        continue block16;
                    }
                    case "expire": {
                        Object object = DnsInquireHelper.getInteger(elements.item(j).getTextContent());
                        Domain domain2 = domain;
                        domain2.setSoaExpire((Integer)object);
                        continue block16;
                    }
                    case "ttl": {
                        Object object = DnsInquireHelper.getInteger(elements.item(j).getTextContent());
                        Domain domain2 = domain;
                        domain2.setSoaTtl((Integer)object);
                        continue block16;
                    }
                    case "email": {
                        Object object = elements.item(j).getTextContent();
                        Domain domain2 = domain;
                        domain2.setSoaEmail((String)object);
                        continue block16;
                    }
                    case "default": {
                        Object object = DnsInquireHelper.getInteger(elements.item(j).getTextContent());
                        Domain domain2 = domain;
                        domain2.setSoaDefault((Integer)object);
                    }
                }
            }
        }
        return domain;
    }

    private static Domain updatingNS(Document doc, Domain domain) {
        NodeList nsList = doc.getElementsByTagName("nserver");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nsList.getLength(); ++i) {
            Node n = nsList.item(i);
            NodeList elements = n.getChildNodes();
            for (int j = 0; j < elements.getLength(); ++j) {
                if (!"name".equals(elements.item(j).getNodeName().toLowerCase())) continue;
                sb.append(elements.item(j).getTextContent().trim()).append("\n");
            }
        }
        String string = sb.toString();
        Domain domain2 = domain;
        domain2.setNameservers(string);
        return domain;
    }

    private static ResourceRecord getRRFromNode(Node node, Domain domain) {
        ResourceRecord resourceRecord;
        String string;
        String name = null;
        String value = null;
        String type = null;
        Object ttl = null;
        Object pref = null;
        ResourceRecord rr = null;
        NodeList elements = node.getChildNodes();
        block14: for (int i = 0; i < elements.getLength(); ++i) {
            Node n = elements.item(i);
            switch (n.getNodeName().toLowerCase()) {
                case "name": {
                    name = n.getTextContent();
                    continue block14;
                }
                case "value": {
                    value = n.getTextContent();
                    if (!Ip.valid(value)) continue block14;
                    Ip.getOrCrate(value);
                    continue block14;
                }
                case "type": {
                    type = n.getTextContent();
                    continue block14;
                }
                case "ttl": {
                    ttl = DnsInquireHelper.getInteger(n.getTextContent());
                    continue block14;
                }
                case "pref": {
                    pref = DnsInquireHelper.getInteger(n.getTextContent());
                }
            }
        }
        if (name != null && type != null && value != null) {
            rr = ResourceRecord.getOrCreate(domain, name, type);
            string = value;
            resourceRecord = rr;
            resourceRecord.setValue(string);
        }
        string = ttl;
        resourceRecord = rr;
        resourceRecord.setTtl((Integer)((Object)string));
        string = pref;
        resourceRecord = rr;
        resourceRecord.setPref((Integer)((Object)string));
        rr.save();
        return rr;
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            Logger.error((String)ex.getLocalizedMessage(), (Throwable)ex);
            return 0;
        }
    }

    private boolean getUpdateStatus(Document doc) {
        Node status;
        doc.getDocumentElement().normalize();
        NodeList statusConfigList = doc.getElementsByTagName("status");
        Node node = status = statusConfigList.getLength() > 0 ? statusConfigList.item(0) : null;
        if (status == null) {
            return false;
        }
        NodeList layerConfigList = status.getChildNodes();
        for (int i = 0; i < layerConfigList.getLength(); ++i) {
            Node n = layerConfigList.item(i);
            if (!n.getTextContent().toLowerCase().equals("success")) continue;
            return true;
        }
        return false;
    }
}

