/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import com.typesafe.config.ConfigFactory;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import models.DnsEntry;
import models.Domain;
import models.ResourceRecord;
import models.SubDomain;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DnsUpdateHelper {
    private static final String AUTODNS_HOST = ConfigFactory.load().getString("autodns.host");
    private static final String AUTODNS_USERNAME = ConfigFactory.load().getString("autodns.user");
    private static final String AUTODNS_PASSWORD = ConfigFactory.load().getString("autodns.pass");
    private static final String AUTODNS_CONTEXT = ConfigFactory.load().getString("autodns.context");
    private static final String AUTODNS_NS_1 = ConfigFactory.load().getString("autodns.ns1");
    private static final String AUTODNS_NS_2 = ConfigFactory.load().getString("autodns.ns2");
    private static final String AUTODNS_NS_3 = ConfigFactory.load().getString("autodns.ns3");
    private static final String AUTODNS_NS_4 = ConfigFactory.load().getString("autodns.ns4");
    private Domain domain;
    private static final int SUBDOMAIN_TTL = DnsUpdateHelper.parseInteger("autodns.subdomain.ttl", 60);
    private static final int DOMAIN_TTL = DnsUpdateHelper.parseInteger("autodns.domain.ttl", 3600);
    private static final int NS_TTL = DnsUpdateHelper.parseInteger("autodns.nameserver.ttl", 86400);

    public DnsUpdateHelper(Domain domain) {
        this.domain = domain;
    }

    public void update() {
        String message = this.getHeader() + this.buildUpdateList() + this.getFooter();
        Domain domain = this.domain;
        String string = null;
        string = domain.getName();
        Logger.debug((String)("@" + System.currentTimeMillis() + " sending Update for " + string + ":\n" + message + "\n"));
        this.performUpdate(message);
    }

    private String getHeader() {
        Domain domain = this.domain;
        String string = null;
        string = domain.getName();
        StringBuilder stringBuilder = new StringBuilder().append("<request><auth><user>").append(AUTODNS_USERNAME).append("</user><password>").append(AUTODNS_PASSWORD).append("</password><context>").append(AUTODNS_CONTEXT).append("</context></auth><task><code>0202</code><zone><internal_ns>").append(AUTODNS_NS_1).append("</internal_ns><name>").append(string).append("</name><ns_action>complete</ns_action><main><value>");
        domain = this.domain;
        string = null;
        string = domain.getIp();
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("</value><ttl>").append(DOMAIN_TTL).append("</ttl></main><www_include>1</www_include><soa><ttl>86400</ttl><refresh>39940</refresh><retry>14400</retry><expire>604800</expire><email>");
        domain = this.domain;
        string = null;
        string = domain.getSoaEmail();
        return stringBuilder2.append(string).append("</email></soa><nserver><name>").append(AUTODNS_NS_1).append("</name><ttl>").append(NS_TTL).append("</ttl></nserver><nserver><name>").append(AUTODNS_NS_2).append("</name><ttl>").append(NS_TTL).append("</ttl></nserver><nserver><name>").append(AUTODNS_NS_3).append("</name><ttl>").append(NS_TTL).append("</ttl></nserver><nserver><name>").append(AUTODNS_NS_4).append("</name><ttl>").append(NS_TTL).append("</ttl></nserver><allow_transfer_from/><free/>").toString();
    }

    private String getFooter() {
        return "</zone><ns_group>default</ns_group><ctid/></task></request>";
    }

    private void updateEntries() {
        Object object;
        Model model;
        for (DnsEntry entry : this.domain.findNeedsToChanged()) {
            model = entry;
            object = null;
            object = model.getUpdatedIp();
            model = entry;
            model.setActualIp((String)object);
            model = entry;
            object = null;
            object = model.getUpdatedIp6();
            model = entry;
            model.setActualIp6((String)object);
            if (entry.needsUpdate6()) {
                object = new Date();
                model = entry;
                model.setUpdated6((Date)object);
            } else {
                object = new Date();
                model = entry;
                model.setUpdated((Date)object);
            }
            Logger.info((String)("@" + System.currentTimeMillis() + " did update for " + (Object)((Object)entry)));
            entry.save();
        }
        object = false;
        model = this.domain;
        model.setForceUpdate((Boolean)object);
        this.domain.save();
    }

    private void performUpdate(String content) {
        F.Promise xmlPromise = WS.url((String)AUTODNS_HOST).setHeader("Content-Type", "text/xml; charset=utf-8").post(content).map((F.Function)new F.Function<WSResponse, Document>(){

            public Document apply(WSResponse response) {
                Logger.debug((String)("response: " + response.getBody()));
                Document doc = response.asXml();
                if (DnsUpdateHelper.this.getUpdateStatus(doc)) {
                    Domain domain = DnsUpdateHelper.this.domain;
                    String string = null;
                    string = domain.getName();
                    Logger.info((String)("@" + System.currentTimeMillis() + " updating " + string + " success!"));
                    DnsUpdateHelper.this.updateEntries();
                } else {
                    Domain domain = DnsUpdateHelper.this.domain;
                    String string = null;
                    string = domain.getName();
                    Logger.error((String)("@" + System.currentTimeMillis() + " updating " + string + " error:\n"), (Object[])new Object[]{response.getBody()});
                }
                return doc;
            }
        });
    }

    private static String getCName(String fullName, String domainName) {
        return fullName.replace("." + domainName, "").trim();
    }

    private Map<Long, DnsEntry> getUpdates(Domain domain) {
        HashMap<Long, DnsEntry> updates = new HashMap<Long, DnsEntry>();
        for (DnsEntry dnsEntry : domain.findNeedsToChanged()) {
            ResourceRecord rr;
            ResourceRecord resourceRecord = rr = ResourceRecord.getOrCreateFromDNSEntry(dnsEntry);
            Long l = null;
            l = resourceRecord.getId();
            updates.put(l, dnsEntry);
        }
        return updates;
    }

    private String buildUpdateList() {
        StringBuilder sb = new StringBuilder();
        Map<Long, DnsEntry> updates = this.getUpdates(this.domain);
        for (ResourceRecord rr : this.domain.getResourceRecords()) {
            Object object = rr;
            Object object2 = null;
            object2 = ((ResourceRecord)((Object)object)).getId();
            if (updates.containsKey(object2)) {
                object = rr;
                object2 = null;
                object2 = ((ResourceRecord)((Object)object)).getId();
                DnsEntry entry = updates.get(object2);
                object = entry;
                object2 = null;
                object2 = ((DnsEntry)((Object)object)).getToDelete();
                if (!((Boolean)object2).booleanValue()) {
                    object = entry;
                    object2 = null;
                    object2 = ((DnsEntry)((Object)object)).getUpdatedIp6();
                    if (object2 != null) {
                        object = entry;
                        object2 = null;
                        object2 = ((DnsEntry)((Object)object)).getUpdatedIp6();
                        sb.append("<rr>").append("<name>").append(entry.getSubdomainPart()).append("</name>").append("<ttl>" + SUBDOMAIN_TTL + "</ttl>").append("<type>AAAA</type>").append("<value>").append((String)object2).append("</value>").append("</rr>");
                        object = entry;
                        object2 = null;
                        object2 = ((DnsEntry)((Object)object)).getUpdatedIp6();
                        object = rr;
                        ((ResourceRecord)((Object)object)).setValue((String)object2);
                    }
                    object = entry;
                    object2 = null;
                    object2 = ((DnsEntry)((Object)object)).getUpdatedIp();
                    if (object2 != null) {
                        object = entry;
                        object2 = null;
                        object2 = ((DnsEntry)((Object)object)).getName();
                        StringBuilder stringBuilder = new StringBuilder().append((String)object2).append(".");
                        object = entry;
                        object2 = null;
                        object = object2 = ((DnsEntry)((Object)object)).getSubDomain();
                        object2 = null;
                        object2 = ((SubDomain)((Object)object)).getName();
                        String string = stringBuilder.append((String)object2).toString();
                        object = entry;
                        object2 = null;
                        object = object2 = ((DnsEntry)((Object)object)).getDomain();
                        object2 = null;
                        object2 = ((Domain)((Object)object)).getName();
                        StringBuilder stringBuilder2 = sb.append("<rr>").append("<name>").append(DnsUpdateHelper.getCName(string, (String)object2)).append("</name>").append("<ttl>" + SUBDOMAIN_TTL + "</ttl>").append("<type>A</type>").append("<value>");
                        object = entry;
                        object2 = null;
                        object2 = ((DnsEntry)((Object)object)).getUpdatedIp();
                        stringBuilder2.append((String)object2).append("</value>").append("</rr>");
                        object = entry;
                        object2 = null;
                        object2 = ((DnsEntry)((Object)object)).getUpdatedIp();
                        object = rr;
                        ((ResourceRecord)((Object)object)).setValue((String)object2);
                    }
                    rr.save();
                    continue;
                }
                if (rr != null) {
                    rr.delete();
                    Logger.info((String)("@" + System.currentTimeMillis() + " deleted " + (Object)((Object)rr)));
                }
                entry.delete();
                Logger.info((String)("@" + System.currentTimeMillis() + " deleted " + (Object)((Object)entry)));
                continue;
            }
            if (rr.value == null) continue;
            sb.append("<rr>").append("<name>").append(rr.name).append("</name>").append("<ttl>" + SUBDOMAIN_TTL + "</ttl>").append("<type>" + rr.type + "</type>").append("<value>").append(rr.value).append("</value>").append("</rr>");
        }
        return sb.toString();
    }

    private boolean getUpdateStatus(Document doc) {
        Node status;
        doc.getDocumentElement().normalize();
        NodeList statusConfigList = doc.getElementsByTagName("status");
        Node node = status = statusConfigList.getLength() > 0 ? statusConfigList.item(0) : null;
        if (status == null) {
            return false;
        }
        NodeList layerConfigList = status.getChildNodes();
        for (int i = 0; i < layerConfigList.getLength(); ++i) {
            Node n = layerConfigList.item(i);
            if (!n.getTextContent().toLowerCase().equals("success")) continue;
            return true;
        }
        return false;
    }

    private static int parseInteger(String key, int fallback) {
        if (key != null && ConfigFactory.load().hasPath(key)) {
            try {
                return Integer.parseInt(ConfigFactory.load().getString(key));
            }
            catch (NumberFormatException ex) {
                Logger.warn((String)("cannot parse " + ex.getLocalizedMessage()));
            }
        }
        return fallback;
    }
}

