/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import models.Domain;
import models.ResourceRecord;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Ip
extends Model
implements EntityBean {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    public static Model.Finder<Long, Ip> Find = new Model.Finder(Long.class, Ip.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @PropertiesEnhancer.GeneratedSetAccessor
    public String value;
    @PropertiesEnhancer.GeneratedSetAccessor
    public String type;
    private static String _EBEAN_MARKER = "models.Ip";

    public String getValue() {
        return this._ebean_get_value();
    }

    public String getType() {
        return this._ebean_get_type();
    }

    public List<ResourceRecord> getResourceRecords() {
        return ResourceRecord.Find.where().eq("value", (Object)this._ebean_get_value()).order("name ASC").order("value DESC").order("pref ASC").findList();
    }

    public List<Domain> getDomains() {
        return Domain.Find.where().eq("ip", (Object)this._ebean_get_value()).order("name ASC").findList();
    }

    public static Ip getOrCrate(String value) {
        String v = value != null ? value.trim() : value;
        Ip ip = (Ip)((Object)Find.where().eq("value", (Object)v).findUnique());
        if (ip == null && Ip.valid(value)) {
            ip = new Ip();
            String string = v;
            Ip ip2 = ip;
            ip2.setValue(string);
            Matcher matcher = IPV4_PATTERN.matcher(v);
            if (matcher.matches()) {
                string = "ipv4";
                ip2 = ip;
                ip2.setType(string);
            } else {
                string = "ipv6";
                ip2 = ip;
                ip2.setType(string);
            }
            ip.save();
        }
        return ip;
    }

    public static boolean valid(String value) {
        return Ip.validIpv4(value) || Ip.validIpv6(value);
    }

    public static boolean validIpv4(String value) {
        String v;
        Matcher matcher;
        return value != null && (matcher = IPV4_PATTERN.matcher(v = value.trim())).matches();
    }

    public static boolean validIpv6(String value) {
        if (value != null) {
            String v = value.trim();
            Matcher matcher = IPV6_STD_PATTERN.matcher(v);
            if (matcher.matches()) {
                return true;
            }
            matcher = IPV6_HEX_COMPRESSED_PATTERN.matcher(v);
            if (matcher.matches()) {
                return true;
            }
        }
        return false;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setValue(String string) {
        this._ebean_set_value(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setType(String string) {
        this._ebean_set_type(string);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_value() {
        this._ebean_intercept.preGetter("value");
        return this.value;
    }

    protected void _ebean_set_value(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "value", (Object)this._ebean_get_value(), (Object)newValue);
        this.value = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_value() {
        return this.value;
    }

    protected void _ebean_setni_value(String _newValue) {
        this.value = _newValue;
    }

    protected String _ebean_get_type() {
        this._ebean_intercept.preGetter("type");
        return this.type;
    }

    protected void _ebean_set_type(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "type", (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_type() {
        return this.type;
    }

    protected void _ebean_setni_type(String _newValue) {
        this.type = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        Ip ip = new Ip();
        ip.id = this.id;
        ip.value = this.value;
        ip.type = this.type;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        Ip p = (Ip)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.value;
            }
            case 3: {
                return p.type;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Ip p = (Ip)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_value();
            }
            case 3: {
                return p._ebean_get_type();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        Ip p = (Ip)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.value = (String)arg;
                return;
            }
            case 3: {
                p.type = (String)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Ip p = (Ip)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_value((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_type((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "value", "type"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        Ip ip = this;
        synchronized (ip) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Ip)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new Ip();
    }
}

