/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import models.DnsEntry;
import models.Domain;
import models.Ip;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ResourceRecord
extends Model
implements EntityBean {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Constraints.Required
    @PropertiesEnhancer.GeneratedSetAccessor
    public String name;
    @Constraints.Required
    @PropertiesEnhancer.GeneratedSetAccessor
    public String type;
    @PropertiesEnhancer.GeneratedSetAccessor
    public String value;
    @PropertiesEnhancer.GeneratedSetAccessor
    public Integer ttl;
    @PropertiesEnhancer.GeneratedSetAccessor
    public Integer pref;
    @ManyToOne
    @Constraints.Required
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Domain domain;
    public static Model.Finder<Long, ResourceRecord> Find = new Model.Finder(Long.class, ResourceRecord.class);
    public static final Form<ResourceRecord> RECORD_FORM = Form.form(ResourceRecord.class);
    private static String _EBEAN_MARKER = "models.ResourceRecord";

    public ResourceRecord() {
        Integer n = 1000;
        ResourceRecord resourceRecord = this;
        resourceRecord.setTtl(n);
    }

    public static ResourceRecord getOrCreate(Domain domain, String name, String type) {
        ResourceRecord rr = (ResourceRecord)((Object)Find.where().eq("domain", (Object)domain).eq("name", (Object)name).eq("type", (Object)type).findUnique());
        if (rr == null) {
            rr = new ResourceRecord();
            Model model = domain;
            Object object = null;
            object = model.getId();
            object = (Domain)((Object)Domain.Find.byId(object));
            model = rr;
            model.setDomain((Domain)((Object)object));
            object = name.trim();
            model = rr;
            model.setName((String)object);
            object = type.trim();
            model = rr;
            model.setType((String)object);
            rr.save();
        }
        return rr;
    }

    public String getType() {
        return this._ebean_get_type();
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public String getValue() {
        return this._ebean_get_value();
    }

    public Integer getTtl() {
        return this._ebean_get_ttl();
    }

    public Integer getPref() {
        return this._ebean_get_pref();
    }

    public DnsEntry getDnsEntry() {
        ResourceRecord resourceRecord = this;
        Domain domain = null;
        domain = resourceRecord.getDomain();
        return (DnsEntry)((Object)DnsEntry.Find.where().eq("name", (Object)this._ebean_get_name()).eq("domain", (Object)domain).findUnique());
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if ("AAAA".equals(this._ebean_get_type()) && !Ip.validIpv6(this._ebean_get_value())) {
            errors.add(new ValidationError("value", this._ebean_get_value() + " is not a valid IPv6!"));
        }
        if ("A".equals(this._ebean_get_type()) && !Ip.validIpv4(this._ebean_get_value())) {
            errors.add(new ValidationError("value", this._ebean_get_value() + " is not a valid IPv4!"));
        }
        return errors.isEmpty() ? null : errors;
    }

    public String toString() {
        ResourceRecord resourceRecord = this;
        Object object = null;
        object = resourceRecord.getId();
        StringBuilder stringBuilder = new StringBuilder().append(object).append(" ").append(this.name).append(" ").append(this.type).append(" ").append(this.value).append(" ").append(this.ttl).append(" ");
        resourceRecord = this;
        object = null;
        object = resourceRecord.getDomain();
        return stringBuilder.append(((Domain)((Object)object)).toString()).toString();
    }

    public static ResourceRecord getOrCreateFromDNSEntry(DnsEntry dnsEntry) {
        String value;
        String type;
        Model model = dnsEntry;
        Object object = null;
        object = model.getUpdatedIp();
        if (object != null) {
            type = "A";
            model = dnsEntry;
            object = null;
            value = object = model.getActualIp();
        } else {
            type = "AAAA";
            model = dnsEntry;
            object = null;
            value = object = model.getActualIp6();
        }
        model = dnsEntry;
        object = null;
        object = model.getDomain();
        ResourceRecord rr = ResourceRecord.getOrCreate((Domain)((Object)object), dnsEntry.getSubdomainPart(), type);
        object = value;
        model = rr;
        model.setValue((String)object);
        rr.save();
        return rr;
    }

    public static Map<String, String> options() {
        String[] types = new String[]{"A", "AAAA", "CAA", "CNAME", "HINFO", "MX", "NAPTR", "NS", "PTR", "SRV", "TXT"};
        LinkedHashMap<String, String> rrTypes = new LinkedHashMap<String, String>();
        for (String type : types) {
            rrTypes.put(type, type);
        }
        return rrTypes;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setName(String string) {
        this._ebean_set_name(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setType(String string) {
        this._ebean_set_type(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setValue(String string) {
        this._ebean_set_value(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setTtl(Integer n) {
        this._ebean_set_ttl(n);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPref(Integer n) {
        this._ebean_set_pref(n);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Domain getDomain() {
        return this._ebean_get_domain();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDomain(Domain domain) {
        this._ebean_set_domain(domain);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_name() {
        this._ebean_intercept.preGetter("name");
        return this.name;
    }

    protected void _ebean_set_name(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "name", (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_name() {
        return this.name;
    }

    protected void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
    }

    protected String _ebean_get_type() {
        this._ebean_intercept.preGetter("type");
        return this.type;
    }

    protected void _ebean_set_type(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "type", (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_type() {
        return this.type;
    }

    protected void _ebean_setni_type(String _newValue) {
        this.type = _newValue;
    }

    protected String _ebean_get_value() {
        this._ebean_intercept.preGetter("value");
        return this.value;
    }

    protected void _ebean_set_value(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "value", (Object)this._ebean_get_value(), (Object)newValue);
        this.value = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_value() {
        return this.value;
    }

    protected void _ebean_setni_value(String _newValue) {
        this.value = _newValue;
    }

    protected Integer _ebean_get_ttl() {
        this._ebean_intercept.preGetter("ttl");
        return this.ttl;
    }

    protected void _ebean_set_ttl(Integer newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "ttl", (Object)this._ebean_get_ttl(), (Object)newValue);
        this.ttl = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Integer _ebean_getni_ttl() {
        return this.ttl;
    }

    protected void _ebean_setni_ttl(Integer _newValue) {
        this.ttl = _newValue;
    }

    protected Integer _ebean_get_pref() {
        this._ebean_intercept.preGetter("pref");
        return this.pref;
    }

    protected void _ebean_set_pref(Integer newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "pref", (Object)this._ebean_get_pref(), (Object)newValue);
        this.pref = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Integer _ebean_getni_pref() {
        return this.pref;
    }

    protected void _ebean_setni_pref(Integer _newValue) {
        this.pref = _newValue;
    }

    protected Domain _ebean_get_domain() {
        this._ebean_intercept.preGetter("domain");
        return this.domain;
    }

    protected void _ebean_set_domain(Domain newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "domain", (Object)this._ebean_get_domain(), (Object)newValue);
        this.domain = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Domain _ebean_getni_domain() {
        return this.domain;
    }

    protected void _ebean_setni_domain(Domain _newValue) {
        this.domain = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        ResourceRecord resourceRecord = new ResourceRecord();
        resourceRecord.id = this.id;
        resourceRecord.name = this.name;
        resourceRecord.type = this.type;
        resourceRecord.value = this.value;
        resourceRecord.ttl = this.ttl;
        resourceRecord.pref = this.pref;
        resourceRecord.domain = this.domain;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        ResourceRecord p = (ResourceRecord)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.name;
            }
            case 3: {
                return p.type;
            }
            case 4: {
                return p.value;
            }
            case 5: {
                return p.ttl;
            }
            case 6: {
                return p.pref;
            }
            case 7: {
                return p.domain;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        ResourceRecord p = (ResourceRecord)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_name();
            }
            case 3: {
                return p._ebean_get_type();
            }
            case 4: {
                return p._ebean_get_value();
            }
            case 5: {
                return p._ebean_get_ttl();
            }
            case 6: {
                return p._ebean_get_pref();
            }
            case 7: {
                return p._ebean_get_domain();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        ResourceRecord p = (ResourceRecord)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.name = (String)arg;
                return;
            }
            case 3: {
                p.type = (String)arg;
                return;
            }
            case 4: {
                p.value = (String)arg;
                return;
            }
            case 5: {
                p.ttl = (Integer)arg;
                return;
            }
            case 6: {
                p.pref = (Integer)arg;
                return;
            }
            case 7: {
                p.domain = (Domain)((Object)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        ResourceRecord p = (ResourceRecord)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_name((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_type((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_value((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_ttl((Integer)arg);
                return;
            }
            case 6: {
                p._ebean_set_pref((Integer)arg);
                return;
            }
            case 7: {
                p._ebean_set_domain((Domain)((Object)arg));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "name", "type", "value", "ttl", "pref", "domain"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        ResourceRecord resourceRecord = this;
        synchronized (resourceRecord) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((ResourceRecord)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new ResourceRecord();
    }
}

