/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.timeout;

import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.timeout.TimeoutTimerTask;
import com.ning.http.client.providers.netty.timeout.TimeoutsHolder;
import com.ning.http.util.DateUtil;
import org.jboss.netty.util.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    public RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyAsyncHttpProvider provider, TimeoutsHolder timeoutsHolder) {
        super(nettyResponseFuture, provider, timeoutsHolder);
    }

    public void run(Timeout timeout) throws Exception {
        this.timeoutsHolder.cancel();
        if (this.provider.isClose()) {
            return;
        }
        if (!this.nettyResponseFuture.isDone() && !this.nettyResponseFuture.isCancelled()) {
            long age = DateUtil.millisTime() - this.nettyResponseFuture.getStart();
            this.expire("Request timed out to " + this.nettyResponseFuture.getChannelRemoteAddress() + " of " + this.nettyResponseFuture.getRequestTimeoutInMs() + " ms after " + age + " ms", age);
            this.nettyResponseFuture.setRequestTimeoutReached();
        }
    }
}

