/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ning;

import com.fasterxml.jackson.databind.JsonNode;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import play.libs.F;
import play.libs.Json;
import play.libs.ws.WSAuthScheme;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.WSResponse;
import play.libs.ws.WSSignatureCalculator;
import play.libs.ws.ning.NingWSClient;
import play.libs.ws.ning.NingWSRequest;

public class NingWSRequestHolder
implements WSRequestHolder {
    private final String url;
    private String method = "GET";
    private Object body = null;
    private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> queryParameters = new HashMap<String, Collection<String>>();
    private String username = null;
    private String password = null;
    private WSAuthScheme scheme = null;
    private WSSignatureCalculator calculator = null;
    private NingWSClient client = null;
    private int timeout = 0;
    private Boolean followRedirects = null;
    private String virtualHost = null;

    public NingWSRequestHolder(NingWSClient ningWSClient, String string) {
        try {
            this.client = ningWSClient;
            URL uRL = new URL(string);
            this.url = string;
            String string2 = uRL.getUserInfo();
            if (string2 != null) {
                this.setAuth(string2);
            }
            if (uRL.getQuery() != null) {
                this.setQueryString(uRL.getQuery());
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    @Override
    public NingWSRequestHolder setHeader(String string, String string2) {
        if (this.headers.containsKey(string)) {
            Collection<String> collection = this.headers.get(string);
            collection.add(string2);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.headers.put(string, arrayList);
        }
        return this;
    }

    @Override
    public WSRequestHolder setQueryString(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length > 2) {
                throw new RuntimeException(new MalformedURLException("QueryString parameter should not have more than 2 = per part"));
            }
            if (stringArray2.length >= 2) {
                this.setQueryParameter(stringArray2[0], stringArray2[1]);
                continue;
            }
            if (stringArray2.length == 1 && string2.charAt(0) != '=') {
                this.setQueryParameter(stringArray2[0], null);
                continue;
            }
            throw new RuntimeException(new MalformedURLException("QueryString part should not start with an = and not be empty"));
        }
        return this;
    }

    @Override
    public WSRequestHolder setQueryParameter(String string, String string2) {
        if (this.queryParameters.containsKey(string)) {
            Collection<String> collection = this.queryParameters.get(string);
            collection.add(string2);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.queryParameters.put(string, arrayList);
        }
        return this;
    }

    @Override
    public WSRequestHolder setAuth(String string) {
        this.scheme = WSAuthScheme.BASIC;
        if (string.equals("")) {
            throw new RuntimeException(new MalformedURLException("userInfo should not be empty"));
        }
        int n = string.indexOf(":");
        if (n == 0) {
            this.username = "";
            this.password = string.substring(1);
        } else if (n == -1) {
            this.username = string;
            this.password = "";
        } else {
            this.username = string.substring(0, n);
            this.password = string.substring(n + 1);
        }
        return this;
    }

    @Override
    public WSRequestHolder setAuth(String string, String string2) {
        this.username = string;
        this.password = string2;
        this.scheme = WSAuthScheme.BASIC;
        return this;
    }

    @Override
    public WSRequestHolder setAuth(String string, String string2, WSAuthScheme wSAuthScheme) {
        this.username = string;
        this.password = string2;
        this.scheme = wSAuthScheme;
        return this;
    }

    @Override
    public WSRequestHolder sign(WSSignatureCalculator wSSignatureCalculator) {
        this.calculator = wSSignatureCalculator;
        return this;
    }

    @Override
    public WSRequestHolder setFollowRedirects(Boolean bl) {
        this.followRedirects = bl;
        return this;
    }

    @Override
    public WSRequestHolder setVirtualHost(String string) {
        this.virtualHost = string;
        return this;
    }

    @Override
    public WSRequestHolder setTimeout(int n) {
        this.timeout = n;
        return this;
    }

    @Override
    public WSRequestHolder setContentType(String string) {
        return this.setHeader("Content-Type", string);
    }

    @Override
    public WSRequestHolder setMethod(String string) {
        this.method = string;
        return this;
    }

    @Override
    public WSRequestHolder setBody(String string) {
        this.body = string;
        return this;
    }

    @Override
    public WSRequestHolder setBody(JsonNode jsonNode) {
        this.body = jsonNode;
        return this;
    }

    @Override
    public WSRequestHolder setBody(InputStream inputStream) {
        this.body = inputStream;
        return this;
    }

    @Override
    public WSRequestHolder setBody(File file) {
        this.body = file;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Map<String, Collection<String>> getHeaders() {
        return new HashMap<String, Collection<String>>(this.headers);
    }

    @Override
    public Map<String, Collection<String>> getQueryParameters() {
        return new HashMap<String, Collection<String>>(this.queryParameters);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public WSAuthScheme getScheme() {
        return this.scheme;
    }

    @Override
    public WSSignatureCalculator getCalculator() {
        return this.calculator;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    String getVirtualHost() {
        return this.virtualHost;
    }

    @Override
    public F.Promise<WSResponse> get() {
        return this.execute("GET");
    }

    @Override
    public F.Promise<WSResponse> patch(String string) {
        this.setMethod("PATCH");
        return this.executeString(string);
    }

    @Override
    public F.Promise<WSResponse> post(String string) {
        this.setMethod("POST");
        return this.executeString(string);
    }

    @Override
    public F.Promise<WSResponse> put(String string) {
        this.setMethod("PUT");
        return this.executeString(string);
    }

    @Override
    public F.Promise<WSResponse> patch(JsonNode jsonNode) {
        this.setMethod("PATCH");
        return this.executeJson(jsonNode);
    }

    @Override
    public F.Promise<WSResponse> post(JsonNode jsonNode) {
        this.setMethod("POST");
        return this.executeJson(jsonNode);
    }

    @Override
    public F.Promise<WSResponse> put(JsonNode jsonNode) {
        this.setMethod("PUT");
        return this.executeJson(jsonNode);
    }

    @Override
    public F.Promise<WSResponse> patch(InputStream inputStream) {
        this.setMethod("PATCH");
        return this.executeIS(inputStream);
    }

    @Override
    public F.Promise<WSResponse> post(InputStream inputStream) {
        this.setMethod("POST");
        return this.executeIS(inputStream);
    }

    @Override
    public F.Promise<WSResponse> put(InputStream inputStream) {
        this.setMethod("PUT");
        return this.executeIS(inputStream);
    }

    @Override
    public F.Promise<WSResponse> post(File file) {
        this.setMethod("POST");
        return this.executeFile(file);
    }

    @Override
    public F.Promise<WSResponse> put(File file) {
        this.setMethod("PUT");
        return this.executeFile(file);
    }

    @Override
    public F.Promise<WSResponse> delete() {
        return this.execute("DELETE");
    }

    @Override
    public F.Promise<WSResponse> head() {
        return this.execute("HEAD");
    }

    @Override
    public F.Promise<WSResponse> options() {
        return this.execute("OPTIONS");
    }

    @Override
    public F.Promise<WSResponse> execute(String string) {
        this.setMethod(string);
        return this.execute();
    }

    @Override
    public F.Promise<WSResponse> execute() {
        if (this.body == null) {
            NingWSRequest ningWSRequest = new NingWSRequest(this.client, this.method, this.url, this.queryParameters, this.headers);
            return this.execute(ningWSRequest);
        }
        if (this.body instanceof String) {
            return this.executeString((String)this.body);
        }
        if (this.body instanceof JsonNode) {
            return this.executeJson((JsonNode)this.body);
        }
        if (this.body instanceof File) {
            return this.executeFile((File)this.body);
        }
        if (this.body instanceof InputStream) {
            return this.executeIS((InputStream)this.body);
        }
        throw new IllegalStateException("Impossible body: " + this.body);
    }

    private F.Promise<WSResponse> executeString(String string) {
        byte[] byArray;
        String string2;
        FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap = new FluentCaseInsensitiveStringsMap(this.headers);
        String string3 = fluentCaseInsensitiveStringsMap.getFirstValue("Content-Type");
        if (string3 == null) {
            string3 = "text/plain";
        }
        if ((string2 = AsyncHttpProviderUtils.parseCharset((String)string3)) == null) {
            string2 = "utf-8";
            fluentCaseInsensitiveStringsMap.replace("Content-Type", new String[]{string3 + "; charset=utf-8"});
        }
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        NingWSRequest ningWSRequest = new NingWSRequest(this.client, this.method, this.url, this.queryParameters, fluentCaseInsensitiveStringsMap, byArray).setBody(string).setBodyEncoding(string2);
        return this.execute(ningWSRequest);
    }

    private F.Promise<WSResponse> executeJson(JsonNode jsonNode) {
        byte[] byArray;
        FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap = new FluentCaseInsensitiveStringsMap(this.headers);
        fluentCaseInsensitiveStringsMap.replace("Content-Type", new String[]{"application/json; charset=utf-8"});
        String string = Json.stringify((JsonNode)jsonNode);
        try {
            byArray = string.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        NingWSRequest ningWSRequest = new NingWSRequest(this.client, this.method, this.url, this.queryParameters, fluentCaseInsensitiveStringsMap, byArray).setBody(string).setBodyEncoding("utf-8");
        return this.execute(ningWSRequest);
    }

    private F.Promise<WSResponse> executeIS(InputStream inputStream) {
        NingWSRequest ningWSRequest = new NingWSRequest(this.client, this.method, this.url, this.queryParameters, this.headers).setBody(inputStream);
        return this.execute(ningWSRequest);
    }

    private F.Promise<WSResponse> executeFile(File file) {
        NingWSRequest ningWSRequest = new NingWSRequest(this.client, this.method, this.url, this.queryParameters, this.headers).setBody(file);
        return this.execute(ningWSRequest);
    }

    private F.Promise<WSResponse> execute(NingWSRequest ningWSRequest) {
        if (this.timeout > 0) {
            PerRequestConfig perRequestConfig = new PerRequestConfig();
            perRequestConfig.setRequestTimeoutInMs(this.timeout);
            ningWSRequest.setPerRequestConfig(perRequestConfig);
        }
        if (this.followRedirects != null) {
            ningWSRequest.setFollowRedirects(this.followRedirects);
        }
        if (this.virtualHost != null) {
            ningWSRequest.setVirtualHost(this.virtualHost);
        }
        if (this.username != null && this.password != null && this.scheme != null) {
            ningWSRequest.auth(this.username, this.password, this.scheme);
        }
        if (this.calculator != null) {
            this.calculator.sign(ningWSRequest);
        }
        return ningWSRequest.execute();
    }
}

