/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib;

import com.avaje.ebeaninternal.server.lib.DaemonThreadFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaemonScheduleThreadPool
extends ScheduledThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DaemonScheduleThreadPool.class);
    private final String namePrefix;
    private int shutdownWaitSeconds;

    public DaemonScheduleThreadPool(int coreSize, int shutdownWaitSeconds, String namePrefix) {
        super(coreSize, new DaemonThreadFactory(namePrefix));
        this.namePrefix = namePrefix;
        this.shutdownWaitSeconds = shutdownWaitSeconds;
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        DaemonScheduleThreadPool daemonScheduleThreadPool = this;
        synchronized (daemonScheduleThreadPool) {
            if (super.isShutdown()) {
                logger.debug("DaemonScheduleThreadPool {} already shut down", (Object)this.namePrefix);
                return;
            }
            try {
                logger.debug("DaemonScheduleThreadPool {} shutting down...", (Object)this.namePrefix);
                super.shutdown();
                if (!super.awaitTermination(this.shutdownWaitSeconds, TimeUnit.SECONDS)) {
                    logger.info("DaemonScheduleThreadPool shut down timeout exceeded. Terminating running threads.");
                    super.shutdownNow();
                }
            }
            catch (Exception e) {
                logger.error("Error during shutdown of " + this.namePrefix, (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            DaemonScheduleThreadPool.this.shutdown();
        }
    }
}

