/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.loadcontext;

import com.avaje.ebean.bean.BeanLoader;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.LoadBeanBuffer;
import com.avaje.ebeaninternal.api.LoadBeanContext;
import com.avaje.ebeaninternal.api.LoadBeanRequest;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.loadcontext.DLoadBaseContext;
import com.avaje.ebeaninternal.server.loadcontext.DLoadContext;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DLoadBeanContext
extends DLoadBaseContext
implements LoadBeanContext {
    private List<LoadBuffer> bufferList;
    private LoadBuffer currentBuffer;

    public DLoadBeanContext(DLoadContext parent, BeanDescriptor<?> desc, String path, int defaultBatchSize, OrmQueryProperties queryProps) {
        super(parent, desc, path, defaultBatchSize, queryProps);
        this.currentBuffer = this.createBuffer(this.firstBatchSize);
        this.bufferList = this.queryFetch ? new ArrayList() : null;
    }

    protected void configureQuery(SpiQuery<?> query, String lazyLoadProperty) {
        if (this.parent.isReadOnly() != null) {
            query.setReadOnly(this.parent.isReadOnly());
        }
        query.setParentNode(this.objectGraphNode);
        query.setLazyLoadProperty(lazyLoadProperty);
        if (this.queryProps != null) {
            this.queryProps.configureBeanQuery(query);
        }
        if (this.parent.isUseAutofetchManager()) {
            query.setAutofetch(true);
        }
    }

    protected void register(EntityBeanIntercept ebi) {
        ebi.setBeanLoader(0, this.currentBuffer, this.getPersistenceContext());
        if (this.currentBuffer.add(ebi)) {
            this.currentBuffer = this.createBuffer(this.secondaryBatchSize);
        }
    }

    private LoadBuffer createBuffer(int size) {
        LoadBuffer buffer = new LoadBuffer(this, size);
        if (this.bufferList != null) {
            this.bufferList.add(buffer);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSecondaryQuery(OrmQueryRequest<?> parentRequest, int requestedBatchSize, boolean all) {
        if (!this.queryFetch) {
            throw new IllegalStateException("Not expecting loadSecondaryQuery() to be called?");
        }
        DLoadBeanContext dLoadBeanContext = this;
        synchronized (dLoadBeanContext) {
            if (this.bufferList != null) {
                for (LoadBuffer loadBuffer : this.bufferList) {
                    if (!loadBuffer.list.isEmpty()) {
                        boolean loadCache = false;
                        LoadBeanRequest req = new LoadBeanRequest(loadBuffer, parentRequest.getTransaction(), false, null, loadCache);
                        this.parent.getEbeanServer().loadBean(req);
                        if (!this.queryProps.isQueryFetchAll()) break;
                    }
                    this.bufferList = null;
                }
            }
        }
    }

    public static class LoadBuffer
    implements BeanLoader,
    LoadBeanBuffer {
        private final DLoadBeanContext context;
        private final int batchSize;
        private final List<EntityBeanIntercept> list;

        public LoadBuffer(DLoadBeanContext context, int batchSize) {
            this.context = context;
            this.batchSize = batchSize;
            this.list = new ArrayList<EntityBeanIntercept>(batchSize);
        }

        public boolean add(EntityBeanIntercept ebi) {
            this.list.add(ebi);
            return this.batchSize == this.list.size();
        }

        @Override
        public List<EntityBeanIntercept> getBatch() {
            return this.list;
        }

        @Override
        public String getName() {
            return this.context.serverName;
        }

        @Override
        public String getFullPath() {
            return this.context.fullPath;
        }

        @Override
        public BeanDescriptor<?> getBeanDescriptor() {
            return this.context.desc;
        }

        @Override
        public PersistenceContext getPersistenceContext() {
            return this.context.getPersistenceContext();
        }

        @Override
        public void configureQuery(SpiQuery<?> query, String lazyLoadProperty) {
            this.context.configureQuery(query, lazyLoadProperty);
        }

        @Override
        public void loadBean(EntityBeanIntercept ebi) {
            if (this.context.desc.lazyLoadMany(ebi)) {
                return;
            }
            if (this.context.hitCache && this.context.desc.loadFromCache(ebi)) {
                this.list.remove(ebi);
                return;
            }
            if (this.context.hitCache) {
                Iterator<EntityBeanIntercept> iterator = this.list.iterator();
                while (iterator.hasNext()) {
                    EntityBeanIntercept bean = iterator.next();
                    if (!this.context.desc.loadFromCache(bean)) continue;
                    iterator.remove();
                }
            }
            LoadBeanRequest req = new LoadBeanRequest(this, null, true, ebi.getLazyLoadProperty(), this.context.hitCache);
            this.context.desc.getEbeanServer().loadBean(req);
        }
    }
}

