/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.query.CQuery;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundFetch
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(BackgroundFetch.class);
    private final CQuery<?> cquery;
    private final SpiTransaction transaction;

    public BackgroundFetch(CQuery<?> cquery) {
        this.cquery = cquery;
        this.transaction = cquery.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        try {
            BeanCollection<?> bc = this.cquery.continueFetchingInBackground();
            Integer n = bc.size();
            return n;
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            Integer n = 0;
            return n;
        }
        finally {
            try {
                this.cquery.close();
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
            try {
                this.transaction.rollback();
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BackgroundFetch ").append(this.cquery);
        return sb.toString();
    }
}

