/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import play.api.Application;
import play.api.Logger$;
import play.api.Play$;
import play.api.db.DBApi;
import play.api.db.DBPlugin;
import play.api.db.evolutions.DownScript;
import play.api.db.evolutions.Evolution;
import play.api.db.evolutions.Evolutions$;
import play.api.db.evolutions.Evolutions$$anonfun$applicationEvolutions$3$;
import play.api.db.evolutions.Evolutions$$anonfun$applicationEvolutions$3$$anonfun$9$;
import play.api.db.evolutions.Evolutions$$anonfun$evolutionScript$2$;
import play.api.db.evolutions.InconsistentDatabase;
import play.api.db.evolutions.Script;
import play.api.db.evolutions.UpScript;
import play.api.libs.Collections$;
import play.api.libs.Files$;
import play.utils.PlayIO$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Evolutions$ {
    public static final Evolutions$ MODULE$;

    static {
        new Evolutions$();
    }

    public void applyFor(String dbName, File path, boolean autocommit2) {
        Play$.MODULE$.current().plugin(ClassTag$.MODULE$.apply(DBPlugin.class)).map((Function1)new Serializable(dbName, path, autocommit2){
            private final String dbName$1;
            private final File path$1;
            private final boolean autocommit$1;

            public final void apply(DBPlugin db) {
                Seq<Product> script = Evolutions$.MODULE$.evolutionScript(db.api(), this.path$1, db.getClass().getClassLoader(), this.dbName$1);
                Evolutions$.MODULE$.applyScript(db.api(), this.dbName$1, script, this.autocommit$1);
            }
            {
                this.dbName$1 = dbName$1;
                this.path$1 = path$1;
                this.autocommit$1 = autocommit$1;
            }
        });
    }

    public File applyFor$default$2() {
        return new File(".");
    }

    public boolean applyFor$default$3() {
        return true;
    }

    public void updateEvolutionScript(String db, int revision, String comment, String ups, String downs, Application application) {
        File evolutions = application.getFile(this.play$api$db$evolutions$Evolutions$$evolutionsFilename(db, revision));
        Files$.MODULE$.createDirectory(application.getFile(this.evolutionsDirectoryName(db)));
        Files$.MODULE$.writeFileIfChanged(evolutions, new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("|# --- %s\n         |\n         |# --- !Ups\n         |%s\n         |\n         |# --- !Downs\n         |%s\n         |\n         |")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{comment, ups, downs})));
    }

    public String updateEvolutionScript$default$1() {
        return "default";
    }

    public int updateEvolutionScript$default$2() {
        return 1;
    }

    public String updateEvolutionScript$default$3() {
        return "Generated";
    }

    private ResultSet executeQuery(String sql, Connection c) {
        return c.createStatement().executeQuery(sql);
    }

    public boolean play$api$db$evolutions$Evolutions$$execute(String sql, Connection c) {
        return c.createStatement().execute(sql);
    }

    private PreparedStatement prepare(String sql, Connection c) {
        return c.prepareStatement(sql);
    }

    /*
     * WARNING - void declaration
     */
    public void resolve(DBApi api, String db, int revision) {
        Connection connection = api.getConnection(db, true);
        try {
            this.play$api$db$evolutions$Evolutions$$execute(new StringBuilder().append((Object)"update play_evolutions set state = 'applied' where state = 'applying_up' and id = ").append((Object)BoxesRunTime.boxToInteger((int)revision)).toString(), connection);
            this.play$api$db$evolutions$Evolutions$$execute(new StringBuilder().append((Object)"delete from play_evolutions where state = 'applying_down' and id = ").append((Object)BoxesRunTime.boxToInteger((int)revision)).toString(), connection);
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        connection.close();
    }

    public void checkEvolutionsState(DBApi api, String db) {
        Connection connection = api.getConnection(db, true);
        try {
            try {
                ResultSet problem = this.executeQuery("select id, hash, apply_script, revert_script, state, last_problem from play_evolutions where state like 'applying_%'", connection);
                if (problem.next()) {
                    int revision = problem.getInt("id");
                    String state = problem.getString("state");
                    String hash = (String)new StringOps(Predef$.MODULE$.augmentString(problem.getString("hash"))).take(7);
                    String string = state;
                    String string2 = "applying_up".equals(string) ? problem.getString("apply_script") : problem.getString("revert_script");
                    String script = string2;
                    String error = problem.getString("last_problem");
                    Play$.MODULE$.logger().error((Function0)new Serializable(error){
                        private final String error$1;

                        public final String apply() {
                            return this.error$1;
                        }
                        {
                            this.error$1 = error$1;
                        }
                    });
                    String string3 = state;
                    String string4 = "applying_up";
                    String humanScript = new StringBuilder().append((Object)"# --- Rev:").append((Object)BoxesRunTime.boxToInteger((int)revision)).append((Object)",").append((Object)(!(string3 != null ? !string3.equals(string4) : string4 != null) ? "Ups" : "Downs")).append((Object)" - ").append((Object)hash).append((Object)"\n\n").append((Object)script).toString();
                    throw new InconsistentDatabase(db, humanScript, error, revision);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof InconsistentDatabase) {
                    InconsistentDatabase inconsistentDatabase = (InconsistentDatabase)((Object)throwable2);
                    throw inconsistentDatabase;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                this.createPlayEvolutionsTable$1(connection);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void applyScript(DBApi api, String db, Seq<Script> script, boolean autocommit2) {
        void var7_7;
        void var5_5;
        String message;
        block9: {
            Connection connection = api.getConnection(db, autocommit2);
            this.checkEvolutionsState(api, db);
            IntRef applying = IntRef.create((int)-1);
            ObjectRef lastScript = ObjectRef.create(null);
            try {
                Object object;
                try {
                    script.foreach((Function1)new Serializable(connection, applying, lastScript){
                        public final Connection connection$1;
                        private final IntRef applying$1;
                        private final ObjectRef lastScript$1;

                        public final boolean apply(Script s) {
                            this.lastScript$1.elem = s;
                            this.applying$1.elem = s.evolution().revision();
                            Evolutions$.MODULE$.play$api$db$evolutions$Evolutions$$logBefore$1(s, this.connection$1);
                            s.statements().foreach((Function1)new Serializable(this){
                                private final /* synthetic */ anonfun.applyScript.1 $outer;

                                public final boolean apply(String sql) {
                                    return Evolutions$.MODULE$.play$api$db$evolutions$Evolutions$$execute(sql, this.$outer.connection$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            return Evolutions$.MODULE$.play$api$db$evolutions$Evolutions$$logAfter$1(s, this.connection$1);
                        }
                        {
                            this.connection$1 = connection$1;
                            this.applying$1 = applying$1;
                            this.lastScript$1 = lastScript$1;
                        }
                    });
                    if (!autocommit2) {
                        connection.commit();
                    }
                    object = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    String string;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    Throwable throwable3 = e;
                    if (throwable3 instanceof SQLException) {
                        SQLException sQLException = (SQLException)throwable3;
                        string = new StringBuilder().append((Object)sQLException.getMessage()).append((Object)" [ERROR:").append((Object)BoxesRunTime.boxToInteger((int)sQLException.getErrorCode())).append((Object)", SQLSTATE:").append((Object)sQLException.getSQLState()).append((Object)"]").toString();
                    } else {
                        string = throwable3.getMessage();
                    }
                    message = string;
                    if (!autocommit2) break block9;
                    Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.updateLastProblem$1(message, applying.elem, connection));
                    object = bl;
                }
            }
            catch (Throwable throwable) {
                var5_5.close();
                throw throwable;
            }
            connection.close();
            this.checkEvolutionsState(api, db);
            return;
        }
        Play$.MODULE$.logger().error((Function0)new Serializable(message){
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        });
        var5_5.rollback();
        String humanScript = new StringBuilder().append((Object)"# --- Rev:").append((Object)BoxesRunTime.boxToInteger((int)((Script)var7_7.elem).evolution().revision())).append((Object)",").append((Object)((Script)var7_7.elem instanceof UpScript ? "Ups" : "Downs")).append((Object)" - ").append((Object)((Script)var7_7.elem).evolution().hash()).append((Object)"\n\n").append((Object)((Script)var7_7.elem instanceof UpScript ? ((Script)var7_7.elem).evolution().sql_up() : ((Script)var7_7.elem).evolution().sql_down())).toString();
        throw new InconsistentDatabase(db, humanScript, message, ((Script)var7_7.elem).evolution().revision());
    }

    public String toHumanReadableScript(Seq<Script> script) {
        String txt = ((TraversableOnce)script.map((Function1)new Serializable(){

            public final String apply(Script x0$1) {
                Script script;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            script = x0$1;
                            if (!(script instanceof UpScript)) break block2;
                            UpScript upScript = (UpScript)script;
                            Evolution ev = upScript.evolution();
                            String sql = upScript.sql();
                            string = new StringBuilder().append((Object)"# --- Rev:").append((Object)BoxesRunTime.boxToInteger((int)ev.revision())).append((Object)",Ups - ").append(new StringOps(Predef$.MODULE$.augmentString(ev.hash())).take(7)).append((Object)"\n").append((Object)sql).append((Object)"\n").toString();
                            break block3;
                        }
                        if (!(script instanceof DownScript)) break block4;
                        DownScript downScript = (DownScript)script;
                        Evolution ev = downScript.evolution();
                        String sql = downScript.sql();
                        string = new StringBuilder().append((Object)"# --- Rev:").append((Object)BoxesRunTime.boxToInteger((int)ev.revision())).append((Object)",Downs - ").append(new StringOps(Predef$.MODULE$.augmentString(ev.hash())).take(7)).append((Object)"\n").append((Object)sql).append((Object)"\n").toString();
                    }
                    return string;
                }
                throw new MatchError((Object)script);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String hasDownWarning = "# !!! WARNING! This script contains DOWNS evolutions that are likely destructives\n\n";
        return script.exists((Function1)new Serializable(){

            public final boolean apply(Script x$3) {
                return x$3 instanceof DownScript;
            }
        }) ? new StringBuilder().append((Object)hasDownWarning).append((Object)txt).toString() : txt;
    }

    public Seq<Product> evolutionScript(DBApi api, File path, ClassLoader applicationClassloader, String db) {
        Seq<Evolution> application = this.applicationEvolutions(path, applicationClassloader, db);
        return (Seq)Option$.MODULE$.apply(application).filterNot((Function1)new Serializable(){

            public final boolean apply(Seq<Evolution> x$4) {
                return x$4.isEmpty();
            }
        }).map((Function1)new Serializable(api, db){
            private final DBApi api$1;
            private final String db$1;

            public final Seq<Product> apply(Seq<Evolution> x0$2) {
                Seq<Evolution> seq = x0$2;
                Seq<Evolution> database = Evolutions$.MODULE$.databaseEvolutions(this.api$1, this.db$1);
                Tuple2 tuple2 = database.span((Function1)new anonfun$evolutionScript$2$$anonfun$4(this, seq));
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Seq nonConflictingDowns = (Seq)tuple2._1();
                    Seq dRest = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)nonConflictingDowns, (Object)dRest);
                    Seq nonConflictingDowns2 = (Seq)tuple23._1();
                    Seq dRest2 = (Seq)tuple23._2();
                    Tuple2 tuple24 = seq.span((Function1)new anonfun$evolutionScript$2$$anonfun$5(this, database));
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        Seq nonConflictingUps = (Seq)tuple24._1();
                        Seq uRest = (Seq)tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)nonConflictingUps, (Object)uRest);
                        Seq nonConflictingUps2 = (Seq)tuple26._1();
                        Seq uRest2 = (Seq)tuple26._2();
                        Tuple2<Seq<Evolution>, Seq<Evolution>> tuple27 = Evolutions$.MODULE$.conflictings((Seq<Evolution>)dRest2, (Seq<Evolution>)uRest2);
                        if (tuple27 != null) {
                            Tuple2 tuple28;
                            Seq conflictingDowns = (Seq)tuple27._1();
                            Seq conflictingUps = (Seq)tuple27._2();
                            Tuple2 tuple29 = tuple28 = new Tuple2((Object)conflictingDowns, (Object)conflictingUps);
                            Seq conflictingDowns2 = (Seq)tuple29._1();
                            Seq conflictingUps2 = (Seq)tuple29._2();
                            Seq ups = (Seq)((TraversableLike)((SeqLike)nonConflictingUps2.$plus$plus((GenTraversableOnce)conflictingUps2, Seq$.MODULE$.canBuildFrom())).reverse()).map((Function1)new Serializable(this){

                                public final UpScript apply(Evolution e) {
                                    return new UpScript(e, e.sql_up());
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            Seq downs = (Seq)((TraversableLike)nonConflictingDowns2.$plus$plus((GenTraversableOnce)conflictingDowns2, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){

                                public final DownScript apply(Evolution e) {
                                    return new DownScript(e, e.sql_down());
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            Seq seq2 = (Seq)downs.$plus$plus((GenTraversableOnce)ups, Seq$.MODULE$.canBuildFrom());
                            return seq2;
                        }
                        throw new MatchError(tuple27);
                    }
                    throw new MatchError((Object)tuple24);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.api$1 = api$1;
                this.db$1 = db$1;
            }
        }).getOrElse((Function0)new Serializable(){

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
    }

    public Tuple2<Seq<Evolution>, Seq<Evolution>> conflictings(Seq<Evolution> downRest, Seq<Evolution> upRest) {
        return ((GenericTraversableTemplate)((SeqLike)((TraversableLike)((SeqLike)downRest.zip(upRest, Seq$.MODULE$.canBuildFrom())).reverse()).dropWhile((Function1)new Serializable(){

            public final boolean apply(Tuple2<Evolution, Evolution> x0$3) {
                Tuple2<Evolution, Evolution> tuple2 = x0$3;
                if (tuple2 != null) {
                    Evolution down = (Evolution)tuple2._1();
                    Evolution up = (Evolution)tuple2._2();
                    String string = down.hash();
                    String string2 = up.hash();
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).reverse()).unzip((Function1)Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Evolution> databaseEvolutions(DBApi api, String db) {
        Seq seq;
        Connection connection = api.getConnection(db, true);
        this.checkEvolutionsState(api, db);
        try {
            seq = Collections$.MODULE$.unfoldLeft((Object)this.executeQuery("\n            select id, hash, apply_script, revert_script from play_evolutions order by id\n        ", connection), (Function1)new Serializable(){

                public final Option<Tuple2<ResultSet, Evolution>> apply(ResultSet rs) {
                    boolean bl;
                    block4: {
                        None$ none$;
                        block3: {
                            block2: {
                                bl = rs.next();
                                if (bl) break block2;
                                none$ = None$.MODULE$;
                                break block3;
                            }
                            if (!bl) break block4;
                            none$ = new Some((Object)new Tuple2((Object)rs, (Object)new Evolution(rs.getInt(1), rs.getString(3), rs.getString(4))));
                        }
                        return none$;
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
            });
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        connection.close();
        return seq;
    }

    private String evolutionsDirectoryName(String db) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"conf/evolutions/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db}));
    }

    public String play$api$db$evolutions$Evolutions$$evolutionsFilename(String db, int revision) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"conf/evolutions/", "/", ".sql"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db, BoxesRunTime.boxToInteger((int)revision)}));
    }

    public String play$api$db$evolutions$Evolutions$$evolutionsResourceName(String db, int revision) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"evolutions/", "/", ".sql"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db, BoxesRunTime.boxToInteger((int)revision)}));
    }

    public Seq<Evolution> applicationEvolutions(File path, ClassLoader applicationClassloader, String db) {
        Regex upsMarker = new StringOps(Predef$.MODULE$.augmentString("^#.*!Ups.*$")).r();
        Regex downsMarker = new StringOps(Predef$.MODULE$.augmentString("^#.*!Downs.*$")).r();
        String UPS = "UPS";
        String DOWNS = "DOWNS";
        String UNKNOWN = "UNKNOWN";
        Serializable mapUpsAndDowns = new Serializable(upsMarker, downsMarker, UPS, DOWNS, UNKNOWN){
            private final Regex upsMarker$1;
            private final Regex downsMarker$1;
            private final String UPS$1;
            private final String DOWNS$1;
            private final String UNKNOWN$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                Option option2 = this.upsMarker$1.unapplySeq(A1);
                String string = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0 ? this.UPS$1 : (!(option = this.downsMarker$1.unapplySeq(A1)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0 ? this.DOWNS$1 : this.UNKNOWN$1);
                return (B1)string;
            }

            public final boolean isDefinedAt(String x1) {
                Option option;
                String string = x1;
                Option option2 = this.upsMarker$1.unapplySeq((CharSequence)string);
                boolean bl = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0 ? true : (!(option = this.downsMarker$1.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0 ? true : true);
                return bl;
            }
            {
                this.upsMarker$1 = upsMarker$1;
                this.downsMarker$1 = downsMarker$1;
                this.UPS$1 = UPS$1;
                this.DOWNS$1 = DOWNS$1;
                this.UNKNOWN$1 = UNKNOWN$1;
            }
        };
        Serializable isMarker = new Serializable(upsMarker, downsMarker){
            private final Regex upsMarker$1;
            private final Regex downsMarker$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x2;
                Option option2 = this.upsMarker$1.unapplySeq(A1);
                Boolean bl = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0 ? BoxesRunTime.boxToBoolean((boolean)true) : (!(option = this.downsMarker$1.unapplySeq(A1)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0 ? BoxesRunTime.boxToBoolean((boolean)true) : BoxesRunTime.boxToBoolean((boolean)false));
                return (B1)bl;
            }

            public final boolean isDefinedAt(String x2) {
                Option option;
                String string = x2;
                Option option2 = this.upsMarker$1.unapplySeq((CharSequence)string);
                boolean bl = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0 ? true : (!(option = this.downsMarker$1.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0 ? true : true);
                return bl;
            }
            {
                this.upsMarker$1 = upsMarker$1;
                this.downsMarker$1 = downsMarker$1;
            }
        };
        return (Seq)((SeqLike)((TraversableLike)Collections$.MODULE$.unfoldLeft((Object)BoxesRunTime.boxToInteger((int)1), (Function1)new Serializable(path, applicationClassloader, db){
            private final File path$2;
            public final ClassLoader applicationClassloader$1;
            public final String db$2;

            public final Option<Tuple2<Object, Tuple2<Object, String>>> apply(int revision) {
                return Option$.MODULE$.apply((Object)new File(this.path$2, Evolutions$.MODULE$.play$api$db$evolutions$Evolutions$$evolutionsFilename(this.db$2, revision))).filter((Function1)new Serializable(this){

                    public final boolean apply(File x$10) {
                        return x$10.exists();
                    }
                }).map((Function1)new Serializable(this){

                    public final FileInputStream apply(File x$11) {
                        return new FileInputStream(x$11);
                    }
                }).orElse((Function0)new Serializable(this, revision){
                    private final /* synthetic */ anonfun.applicationEvolutions.1 $outer;
                    private final int revision$2;

                    public final Option<InputStream> apply() {
                        return Option$.MODULE$.apply((Object)this.$outer.applicationClassloader$1.getResourceAsStream(Evolutions$.MODULE$.play$api$db$evolutions$Evolutions$$evolutionsResourceName(this.$outer.db$2, this.revision$2)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.revision$2 = revision$2;
                    }
                }).map((Function1)new Serializable(this, revision){
                    private final int revision$2;

                    public final Tuple2<Object, Tuple2<Object, String>> apply(InputStream stream) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.revision$2 + 1)), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.revision$2), (Object)PlayIO$.MODULE$.readStreamAsString(stream, Codec$.MODULE$.UTF8())));
                    }
                    {
                        this.revision$2 = revision$2;
                    }
                });
            }
            {
                this.path$2 = path$2;
                this.applicationClassloader$1 = applicationClassloader$1;
                this.db$2 = db$2;
            }
        }).sortBy((Function1)new Serializable(){

            public final int apply(Tuple2<Object, String> x$12) {
                return x$12._1$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(UPS, DOWNS, (PartialFunction)mapUpsAndDowns, (PartialFunction)isMarker){
            private final String UPS$1;
            private final String DOWNS$1;
            public final PartialFunction mapUpsAndDowns$1;
            public final PartialFunction isMarker$1;

            public final Evolution apply(Tuple2<Object, String> x0$4) {
                Tuple2<Object, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    int revision = tuple2._1$mcI$sp();
                    String script = (String)tuple2._2();
                    Map parsed = ((TraversableLike)((IterableLike)Collections$.MODULE$.unfoldLeft((Object)new Tuple2((Object)"", Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(script)).split('\n')).toList().map((Function1)new Serializable(this){

                        public final String apply(String x$13) {
                            return x$13.trim();
                        }
                    }, List$.MODULE$.canBuildFrom())), (Function1)new Serializable(this){
                        private final /* synthetic */ anonfun.applicationEvolutions.3 $outer;

                        public final Option<Tuple2<Tuple2<String, List<String>>, Tuple2<String, String>>> apply(Tuple2<String, List<String>> x0$5) {
                            Tuple2<String, List<String>> tuple2;
                            block4: {
                                Tuple2 tuple22;
                                block5: {
                                    None$ none$;
                                    block3: {
                                        Tuple2 tuple23;
                                        block2: {
                                            List list;
                                            tuple2 = x0$5;
                                            if (tuple2 == null || !Nil$.MODULE$.equals(list = (List)tuple2._2())) break block2;
                                            none$ = None$.MODULE$;
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        String context = (String)tuple2._1();
                                        List lines = (List)tuple2._2();
                                        tuple22 = lines.span((Function1)new anonfun$applicationEvolutions$3$$anonfun$9$$anonfun$10(this));
                                        if (tuple22 == null) break block5;
                                        List some = (List)tuple22._1();
                                        List next = (List)tuple22._2();
                                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)some, (Object)next);
                                        List some2 = (List)tuple24._1();
                                        List next2 = (List)tuple24._2();
                                        none$ = new Some((Object)new Tuple2(next2.headOption().map((Function1)new Serializable(this, next2){
                                            private final /* synthetic */ anonfun$applicationEvolutions$3$$anonfun$9 $outer;
                                            private final List next$1;

                                            public final Tuple2<String, List<String>> apply(String c) {
                                                return new Tuple2(this.$outer.play$api$db$evolutions$Evolutions$$anonfun$$anonfun$$$outer().mapUpsAndDowns$1.apply((Object)c), this.next$1.tail());
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.next$1 = next$1;
                                            }
                                        }).getOrElse((Function0)new Serializable(this){

                                            public final Tuple2<String, Nil$> apply() {
                                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)Nil$.MODULE$);
                                            }
                                        }), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)context), (Object)some2.mkString("\n"))));
                                    }
                                    return none$;
                                }
                                throw new MatchError((Object)tuple22);
                            }
                            throw new MatchError(tuple2);
                        }

                        public /* synthetic */ anonfun.applicationEvolutions.3 play$api$db$evolutions$Evolutions$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }).reverse()).drop(1)).groupBy((Function1)new Serializable(this){

                        public final String apply(Tuple2<String, String> i) {
                            return (String)i._1();
                        }
                    }).mapValues((Function1)new Serializable(this){

                        public final String apply(Seq<Tuple2<String, String>> x$15) {
                            return ((TraversableOnce)x$15.map((Function1)new Serializable(this){

                                public final String apply(Tuple2<String, String> x$16) {
                                    return (String)x$16._2();
                                }
                            }, Seq$.MODULE$.canBuildFrom())).mkString("\n").trim();
                        }
                    });
                    Evolution evolution = new Evolution(revision, (String)parsed.get((Object)this.UPS$1).getOrElse((Function0)new Serializable(this){

                        public final String apply() {
                            return "";
                        }
                    }), (String)parsed.get((Object)this.DOWNS$1).getOrElse((Function0)new Serializable(this){

                        public final String apply() {
                            return "";
                        }
                    }));
                    return evolution;
                }
                throw new MatchError(tuple2);
            }
            {
                this.UPS$1 = UPS$1;
                this.DOWNS$1 = DOWNS$1;
                this.mapUpsAndDowns$1 = mapUpsAndDowns$1;
                this.isMarker$1 = isMarker$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).reverse();
    }

    private final void createPlayEvolutionsTable$1(Connection conn) {
        try {
            this.play$api$db$evolutions$Evolutions$$execute("\n              create table play_evolutions (\n                  id int not null primary key, hash varchar(255) not null,\n                  applied_at timestamp not null,\n                  apply_script text,\n                  revert_script text,\n                  state varchar(255),\n                  last_problem text\n              )\n          ", conn);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable ex = (Throwable)option.get();
            Logger$.MODULE$.warn((Function0)new Serializable(){

                public final String apply() {
                    return "could not create play_evolutions table";
                }
            }, (Function0)new Serializable(ex){
                private final Throwable ex$1;

                public final Throwable apply() {
                    return this.ex$1;
                }
                {
                    this.ex$1 = ex$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public final void play$api$db$evolutions$Evolutions$$logBefore$1(Script s, Connection conn) {
        Script script;
        block4: {
            block3: {
                block2: {
                    script = s;
                    if (!(script instanceof UpScript)) break block2;
                    UpScript upScript = (UpScript)script;
                    Evolution e = upScript.evolution();
                    PreparedStatement ps = this.prepare("insert into play_evolutions values(?, ?, ?, ?, ?, ?, ?)", conn);
                    ps.setInt(1, e.revision());
                    ps.setString(2, e.hash());
                    ps.setDate(3, new Date(System.currentTimeMillis()));
                    ps.setString(4, e.sql_up());
                    ps.setString(5, e.sql_down());
                    ps.setString(6, "applying_up");
                    ps.setString(7, "");
                    ps.execute();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(script instanceof DownScript)) break block4;
                DownScript downScript = (DownScript)script;
                Evolution e = downScript.evolution();
                this.play$api$db$evolutions$Evolutions$$execute(new StringBuilder().append((Object)"update play_evolutions set state = 'applying_down' where id = ").append((Object)BoxesRunTime.boxToInteger((int)e.revision())).toString(), conn);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)script);
    }

    public final boolean play$api$db$evolutions$Evolutions$$logAfter$1(Script s, Connection conn) {
        Script script;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    script = s;
                    if (!(script instanceof UpScript)) break block2;
                    UpScript upScript = (UpScript)script;
                    Evolution e = upScript.evolution();
                    bl = this.play$api$db$evolutions$Evolutions$$execute(new StringBuilder().append((Object)"update play_evolutions set state = 'applied' where id = ").append((Object)BoxesRunTime.boxToInteger((int)e.revision())).toString(), conn);
                    break block3;
                }
                if (!(script instanceof DownScript)) break block4;
                DownScript downScript = (DownScript)script;
                Evolution e = downScript.evolution();
                bl = this.play$api$db$evolutions$Evolutions$$execute(new StringBuilder().append((Object)"delete from play_evolutions where id = ").append((Object)BoxesRunTime.boxToInteger((int)e.revision())).toString(), conn);
            }
            return bl;
        }
        throw new MatchError((Object)script);
    }

    private final boolean updateLastProblem$1(String message, int revision, Connection conn) {
        PreparedStatement ps = this.prepare("update play_evolutions set last_problem = ? where id = ?", conn);
        ps.setString(1, message);
        ps.setInt(2, revision);
        return ps.execute();
    }

    private Evolutions$() {
        MODULE$ = this;
    }
}

