/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import play.api.Logger$;
import play.api.Play$;
import play.api.libs.iteratee.Enumerator;
import play.api.libs.iteratee.Input;
import play.api.mvc.WebSocket;
import play.core.Execution$Implicits$;
import play.core.server.WebSocketable;
import play.core.server.netty.NettyFuture$;
import play.core.server.netty.WebSocketHandler;
import play.core.server.netty.WebSocketHandler$;
import play.core.server.netty.WebSocketHandler$$anon$1$;
import play.core.server.websocket.FrameFormatter;
import play.core.server.websocket.WebSocketHandshake$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class WebSocketHandler$class {
    public static Tuple2 newWebSocketInHandler(WebSocketHandler $this, WebSocket.FrameFormatter frameFormatter, long bufferLimit) {
        FrameFormatter nettyFrameFormatter = (FrameFormatter)frameFormatter;
        WebSocketHandler.WebSocketEnumerator enumerator = $this.new WebSocketHandler.WebSocketEnumerator();
        return new Tuple2(enumerator, (Object)new SimpleChannelUpstreamHandler($this, nettyFrameFormatter, enumerator, bufferLimit){
            private Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> continuationBuffer;
            private final /* synthetic */ WebSocketHandler $outer;
            private final FrameFormatter nettyFrameFormatter$1;
            public final WebSocketHandler.WebSocketEnumerator enumerator$1;
            private final long bufferLimit$1;

            private Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> continuationBuffer() {
                return this.continuationBuffer;
            }

            private void continuationBuffer_$eq(Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>> x$1) {
                this.continuationBuffer = x$1;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
                Object frame;
                Object frame2;
                Object frame3;
                Tuple2 tuple2 = new Tuple2(e.getMessage(), this.continuationBuffer());
                if (tuple2 != null) {
                    Object frame4 = tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (frame4 instanceof ContinuationWebSocketFrame) {
                        Some some;
                        Tuple2 tuple22;
                        ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)frame4;
                        if (option instanceof Some && (tuple22 = (Tuple2)(some = (Some)option).x()) != null) {
                            ChannelBuffer buffer = (ChannelBuffer)tuple22._2();
                            if ((long)(continuationWebSocketFrame.getBinaryData().readableBytes() + buffer.readableBytes()) > this.bufferLimit$1) {
                                this.closeWebSocket(ctx, this.$outer.WebSocketMessageTooLong(), new StringBuilder().append((Object)"Fragmented message too long, configured limit is ").append((Object)BoxesRunTime.boxToLong((long)this.bufferLimit$1)).toString());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame5 = tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (frame5 instanceof ContinuationWebSocketFrame) {
                        Some some;
                        Tuple2 tuple23;
                        ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)frame5;
                        if (option instanceof Some && (tuple23 = (Tuple2)(some = (Some)option).x()) != null) {
                            ChannelBuffer buffer = (ChannelBuffer)tuple23._2();
                            if (!continuationWebSocketFrame.isFinalFragment()) {
                                buffer.writeBytes(continuationWebSocketFrame.getBinaryData());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame6 = tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (frame6 instanceof ContinuationWebSocketFrame) {
                        Some some;
                        Tuple2 tuple24;
                        ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)frame6;
                        if (option instanceof Some && (tuple24 = (Tuple2)(some = (Some)option).x()) != null) {
                            Function1 creator = (Function1)tuple24._1();
                            ChannelBuffer buffer = (ChannelBuffer)tuple24._2();
                            buffer.writeBytes(continuationWebSocketFrame.getBinaryData());
                            this.continuationBuffer_$eq((Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>>)None$.MODULE$);
                            WebSocketFrame finalFrame = (WebSocketFrame)creator.apply((Object)buffer);
                            this.enumerator$1.frameReceived(ctx, new Input.El(this.nettyFrameFormatter$1.fromFrame().apply((Object)finalFrame)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame7 = tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (frame7 instanceof TextWebSocketFrame) {
                        TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)frame7;
                        if (None$.MODULE$.equals(option) && !textWebSocketFrame.isFinalFragment() && this.nettyFrameFormatter$1.fromFrame().isDefinedAt((Object)textWebSocketFrame)) {
                            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((int)Math.min(textWebSocketFrame.getBinaryData().readableBytes() * 2, (int)this.bufferLimit$1));
                            buffer.writeBytes(textWebSocketFrame.getBinaryData());
                            this.continuationBuffer_$eq((Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>>)new Some((Object)new Tuple2((Object)new Serializable(this, buffer, textWebSocketFrame){
                                private final ChannelBuffer buffer$1;
                                private final TextWebSocketFrame x22$1;

                                public final TextWebSocketFrame apply(ChannelBuffer b) {
                                    return new TextWebSocketFrame(true, this.x22$1.getRsv(), this.buffer$1);
                                }
                                {
                                    this.buffer$1 = buffer$1;
                                    this.x22$1 = x22$1;
                                }
                            }, (Object)buffer)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame8 = tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (frame8 instanceof BinaryWebSocketFrame) {
                        BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)frame8;
                        if (None$.MODULE$.equals(option) && !binaryWebSocketFrame.isFinalFragment() && this.nettyFrameFormatter$1.fromFrame().isDefinedAt((Object)binaryWebSocketFrame)) {
                            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((int)Math.min(binaryWebSocketFrame.getBinaryData().readableBytes() * 2, (int)this.bufferLimit$1));
                            buffer.writeBytes(binaryWebSocketFrame.getBinaryData());
                            this.continuationBuffer_$eq((Option<Tuple2<Function1<ChannelBuffer, WebSocketFrame>, ChannelBuffer>>)new Some((Object)new Tuple2((Object)new Serializable(this, buffer, binaryWebSocketFrame){
                                private final ChannelBuffer buffer$2;
                                private final BinaryWebSocketFrame x24$1;

                                public final BinaryWebSocketFrame apply(ChannelBuffer b) {
                                    return new BinaryWebSocketFrame(true, this.x24$1.getRsv(), this.buffer$2);
                                }
                                {
                                    this.buffer$2 = buffer$2;
                                    this.x24$1 = x24$1;
                                }
                            }, (Object)buffer)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object frame9 = tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (frame9 instanceof WebSocketFrame) {
                        WebSocketFrame webSocketFrame = (WebSocketFrame)frame9;
                        if (None$.MODULE$.equals(option) && this.nettyFrameFormatter$1.fromFrame().isDefinedAt((Object)webSocketFrame)) {
                            this.enumerator$1.frameReceived(ctx, new Input.El(this.nettyFrameFormatter$1.fromFrame().apply((Object)webSocketFrame)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                if (tuple2 != null && (frame3 = tuple2._1()) instanceof CloseWebSocketFrame) {
                    CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)frame3;
                    this.closeWebSocket(ctx, closeWebSocketFrame.getStatusCode(), "");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (tuple2 != null && (frame2 = tuple2._1()) instanceof PingWebSocketFrame) {
                    PingWebSocketFrame pingWebSocketFrame = (PingWebSocketFrame)frame2;
                    ctx.getChannel().write((Object)new PongWebSocketFrame(pingWebSocketFrame.getBinaryData()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (tuple2 != null && (frame = tuple2._1()) instanceof WebSocketFrame) {
                    this.closeWebSocket(ctx, this.$outer.WebSocketUnacceptable(), "This WebSocket does not handle frames of that type");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
                e.getCause().printStackTrace();
                e.getChannel().close();
            }

            public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
                this.enumerator$1.frameReceived(ctx, Input.EOF$.MODULE$);
                Play$.MODULE$.logger().trace((Function0<String>)new Serializable(this){

                    public final String apply() {
                        return "disconnected socket";
                    }
                });
            }

            private void closeWebSocket(ChannelHandlerContext ctx, int status, String reason) {
                if (!reason.isEmpty()) {
                    Logger$.MODULE$.trace((Function0<String>)new Serializable(this, reason){
                        private final String reason$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Closing WebSocket because ").append((Object)this.reason$1).toString();
                        }
                        {
                            this.reason$1 = reason$1;
                        }
                    });
                }
                if (ctx.getChannel().isOpen()) {
                    NettyFuture$.MODULE$.ToScala(ctx.getChannel().write((Object)new CloseWebSocketFrame(status, reason))).toScala().flatMap((Function1)new Serializable(this, ctx){
                        private final /* synthetic */ WebSocketHandler$.anon.1 $outer;
                        public final ChannelHandlerContext ctx$1;

                        public final Future<BoxedUnit> apply(Channel _) {
                            return NettyFuture$.MODULE$.ToScala(this.ctx$1.getChannel().close()).toScala().map((Function1)new Serializable(this){
                                private final /* synthetic */ WebSocketHandler$$anon$1$.anonfun.closeWebSocket.2 $outer;

                                public final void apply(Channel _) {
                                    this.$outer.play$core$server$netty$WebSocketHandler$$anon$$anonfun$$$outer().enumerator$1.frameReceived(this.$outer.ctx$1, Input.EOF$.MODULE$);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Execution$Implicits$.MODULE$.internalContext());
                        }

                        public /* synthetic */ WebSocketHandler$.anon.1 play$core$server$netty$WebSocketHandler$$anon$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ctx$1 = ctx$1;
                        }
                    }, Execution$Implicits$.MODULE$.internalContext());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nettyFrameFormatter$1 = nettyFrameFormatter$1;
                this.enumerator$1 = enumerator$1;
                this.bufferLimit$1 = bufferLimit$1;
                this.continuationBuffer = None$.MODULE$;
            }
        });
    }

    public static Enumerator websocketHandshake(WebSocketHandler $this, ChannelHandlerContext ctx, HttpRequest req, MessageEvent e, long bufferLimit, WebSocket.FrameFormatter frameFormatter) {
        Tuple2 tuple2 = $this.newWebSocketInHandler(frameFormatter, bufferLimit);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Enumerator enumerator = (Enumerator)tuple2._1();
            ChannelHandler handler = (ChannelHandler)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)enumerator, (Object)handler);
            Enumerator enumerator2 = (Enumerator)tuple23._1();
            ChannelHandler handler2 = (ChannelHandler)tuple23._2();
            ChannelPipeline p = ctx.getChannel().getPipeline();
            p.replace("handler", "handler", handler2);
            WebSocketHandshake$.MODULE$.shake(ctx, req, bufferLimit);
            return enumerator2;
        }
        throw new MatchError(tuple2);
    }

    public static WebSocketable websocketable(WebSocketHandler $this, HttpRequest req) {
        return new WebSocketable($this, req){
            private final HttpRequest req$1;

            public boolean check() {
                return "WebSocket".equalsIgnoreCase(this.req$1.headers().get("Upgrade"));
            }

            public String getHeader(String header) {
                return this.req$1.headers().get(header);
            }
            {
                this.req$1 = req$1;
            }
        };
    }

    public static void $init$(WebSocketHandler $this) {
        $this.play$core$server$netty$WebSocketHandler$_setter_$WebSocketNormalClose_$eq(1000);
        $this.play$core$server$netty$WebSocketHandler$_setter_$WebSocketUnacceptable_$eq(1003);
        $this.play$core$server$netty$WebSocketHandler$_setter_$WebSocketMessageTooLong_$eq(1009);
        $this.play$core$server$netty$WebSocketHandler$_setter_$play$core$server$netty$WebSocketHandler$$MaxInFlight_$eq(3);
    }
}

