/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.With;
import play.twirl.api.Content;
import views.html.defaultpages.unauthorized;

public class Security {

    public static class Authenticator
    extends Results {
        public String getUsername(Http.Context context) {
            return (String)context.session().get("username");
        }

        public Result onUnauthorized(Http.Context context) {
            return Authenticator.unauthorized((Content)unauthorized.render());
        }
    }

    public static class AuthenticatedAction
    extends Action<Authenticated> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public F.Promise<Result> call(Http.Context context) {
            Authenticator authenticator = ((Authenticated)this.configuration).value().newInstance();
            String string = authenticator.getUsername(context);
            if (string == null) {
                Result result = authenticator.onUnauthorized(context);
                return F.Promise.pure(result);
            }
            try {
                context.request().setUsername(string);
                F.Promise<Result> promise2 = this.delegate.call(context);
                context.request().setUsername(null);
                return promise2;
            }
            catch (Throwable throwable) {
                try {
                    context.request().setUsername(null);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Throwable throwable2) {
                    throw new RuntimeException(throwable2);
                }
            }
        }
    }

    @With(value={AuthenticatedAction.class})
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Authenticated {
        public Class<? extends Authenticator> value() default Authenticator.class;
    }
}

