/*
 * Decompiled with CFR 0.152.
 */
package de.javastream.javassh;

import de.javastream.javassh.Host;
import de.javastream.javassh.SSH;
import de.javastream.javassh.Utils;
import de.javastream.javassh.parser.ProcessParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RSYNC {
    protected Runtime r;
    private int status = 255;
    private static final Logger LOG = Logger.getLogger(RSYNC.class.getName());
    private String options = "-avrz";
    private String prefix = "";
    private boolean targetDelete = false;
    private boolean daemonMonde = false;

    public RSYNC() {
        if (Utils.isWindows()) {
            throw new UnsupportedOperationException("Windows is currently not supported!");
        }
        this.prefix = "rsync ";
        this.r = Runtime.getRuntime();
    }

    public void pull(Host host, String remotePath, String localPath, ProcessParser pp) {
        try {
            String command = this.buildCommand(host) + " " + host.user + "@" + host.url + ":" + remotePath + " " + localPath;
            LOG.log(Level.FINE, "running: {1}", new Object[]{command});
            Process p = this.r.exec(command);
            if (!this.needPassword(host)) {
                this.runProcess(p, pp);
            } else {
                this.status = 255;
                LOG.log(Level.SEVERE, "{0} needs a password. Please add the public ssh-key to {1}", new Object[]{host, host});
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getLocalizedMessage());
        }
    }

    public void push(String localPath, Host host, String remotePath, ProcessParser pp) {
        try {
            String command = this.buildCommand(host) + " " + localPath + " " + host.user + "@" + host.url + ":" + remotePath;
            LOG.log(Level.FINE, "running: {1}", new Object[]{command});
            Process p = this.r.exec(command);
            if (!this.needPassword(host)) {
                this.runProcess(p, pp);
            } else {
                this.status = 255;
                LOG.log(Level.SEVERE, "{0} needs a password. Please add the public ssh-key to {1}", new Object[]{host, host});
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getLocalizedMessage());
        }
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void daemonMode(boolean flag) {
        this.daemonMonde = flag;
    }

    public void targetDelete(boolean flag) {
        this.targetDelete = flag;
    }

    private boolean needPassword(Host host) throws IOException {
        return new SSH(host).needPassword();
    }

    private String buildCommand(Host host) {
        String cmd = this.prefix + " " + this.options;
        if (!this.daemonMonde) {
            cmd = cmd + " -e 'ssh -p " + host.port + "'";
        }
        if (this.targetDelete) {
            cmd = cmd + " --delete ";
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runProcess(Process p, ProcessParser pp) throws IOException {
        InputStream in = p.getInputStream();
        BufferedInputStream buf = new BufferedInputStream(in);
        InputStreamReader inread = new InputStreamReader(buf);
        BufferedReader bufferedreader = new BufferedReader(inread);
        pp.parse(bufferedreader);
        try {
            this.status = p.waitFor();
            LOG.log(Level.FINE, "exit value = {0}", this.status);
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, e.getLocalizedMessage());
        }
        finally {
            bufferedreader.close();
            inread.close();
            buf.close();
            in.close();
        }
    }

    public int getStatus() {
        return this.status;
    }
}

