/**
 * RSYNCTest 19.10.2012
 *
 * @author Philipp Haussleiter
 *
 */
package de.javastream.javassh;

import de.javastream.javassh.parser.SimpeOutputPP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;

public class RSYNCTest extends TestCase {

    private String timestamp = System.currentTimeMillis() + "";
    private final static Host HOST = new Host("root", "localhost", 22);

    @Override
    public void setUp() throws FileNotFoundException, IOException {
        createTestFile("/tmp/" + timestamp + ".txt");
        createTestFile("target/testFile.txt");
    }

    @Override
    public void tearDown() {
        cleanTestFiles("/tmp/" + timestamp + ".txt");
    }

    public void testPull() throws FileNotFoundException, IOException {
        RSYNC rsync = new RSYNC();
        SimpeOutputPP sop = new SimpeOutputPP();
        rsync.pull(HOST, "/tmp/" + timestamp + ".txt", "target/testFile.txt", sop);
        assertTrue(equals("target/testFile.txt", "/tmp/" + timestamp + ".txt"));
    }

    public void testPush() throws FileNotFoundException, IOException {
        RSYNC rsync = new RSYNC();
        SimpeOutputPP sop = new SimpeOutputPP();
        rsync.push("target/testFile.txt", HOST, "/tmp/" + timestamp + ".txt", sop);
        assertTrue(equals("target/testFile.txt", "/tmp/" + timestamp + ".txt"));
    }

    private void createTestFile(String fileName) throws FileNotFoundException, IOException {
        File testFile = new File(fileName);
        FileOutputStream fos = new FileOutputStream(testFile);
        fos.write(timestamp.getBytes());
        fos.close();
    }

    private void cleanTestFiles(String fileName) {
        File testFile = new File(fileName);
        if (testFile.exists()) {
            testFile.delete();
        }
    }

    private boolean equals(final String path1, final String path2) throws FileNotFoundException, IOException {
        File f1 = new File(path1);
        File f2 = new File(path2);
        FileInputStream fis1 = new FileInputStream(f1);
        FileInputStream fis2 = new FileInputStream(f2);
        int a, b;
        while ((a = fis1.read()) != -1) {
            b = fis2.read();
            if (a != b) {
                return false;
            }
        }
        return true;
    }
}
