/**
 * SSHTest 18.10.2012
 *
 * @author Philipp Haussleiter
 *
 */
package de.javastream.javassh;

import de.javastream.javassh.parser.SimpeOutputPP;
import java.io.IOException;
import junit.framework.TestCase;

public class SSHTest extends TestCase {

    private final static Host HOST_DEFAULT_PORT = new Host("root", "localhost");
    private final static Host HOST_PORT = new Host("root", "localhost", 22);

    public void testNeedPassword() throws IOException {
        SSH ssh = new SSH(HOST_DEFAULT_PORT);
        assertFalse(ssh.needPassword());
    }

    public void testConnect() {
        String cmd = "ls -al";
        SSH ssh = new SSH(HOST_DEFAULT_PORT);
        SimpeOutputPP sop = new SimpeOutputPP();
        ssh.runCommand(cmd, sop);
        System.out.println("output for " + cmd + " is " + sop.getOutput());
    }

    public void testConnectWithPort() {
        String cmd = "ls -al";
        SSH ssh = new SSH(HOST_PORT);
        SimpeOutputPP sop = new SimpeOutputPP();
        ssh.runCommand(cmd, sop);
        System.out.println("output for " + cmd + " is " + sop.getOutput());
    }
}
