/*
 * Decompiled with CFR 0.152.
 */
package actions;

import com.ning.http.util.Base64;
import com.typesafe.config.ConfigFactory;
import models.InnoQAccount;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class InnoQBasicAuthAction
extends Action<Object> {
    private static final String AUTHORIZATION = "authorization";
    private static final String REMOTE_USER = "REMOTE_USER";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String REALM = InnoQBasicAuthAction.getRealm();
    private static final String TRUSTERD_IP = InnoQBasicAuthAction.getTrustedIp();

    public F.Promise<Result> call(Http.Context context) throws Throwable {
        String authHeader = context.request().getHeader(AUTHORIZATION);
        String remoteUser = context.request().getHeader(REMOTE_USER);
        String remoteAddress = context.request().remoteAddress();
        if (authHeader == null) {
            return this.sendAuthRequest(context);
        }
        Logger.info((String)("remote IP is " + remoteAddress + " vs " + TRUSTERD_IP));
        if (remoteAddress.equals(TRUSTERD_IP) && remoteUser != null) {
            InnoQAccount account = InnoQAccount.getOrCreate(remoteUser);
            context.request().setUsername(remoteUser);
            return this.delegate.call(context);
        }
        String auth = authHeader.substring(6);
        byte[] decodedAuth = Base64.decode((String)auth);
        String[] credString = new String(decodedAuth, "UTF-8").split(":");
        if (credString == null || credString.length != 2) {
            return this.sendAuthRequest(context);
        }
        String username = credString[0];
        String password = credString[1];
        InnoQAccount authUser = InnoQAccount.authenticate(username, password);
        if (authUser == null) {
            return this.sendAuthRequest(context);
        }
        context.request().setUsername(username);
        return this.delegate.call(context);
    }

    private F.Promise<Result> sendAuthRequest(Http.Context context) {
        context.response().setHeader(WWW_AUTHENTICATE, REALM);
        return F.Promise.pure((Object)InnoQBasicAuthAction.unauthorized());
    }

    private static String getRealm() {
        if (ConfigFactory.load().hasPath("app.name")) {
            return "Basic realm=\"" + ConfigFactory.load().getString("app.name") + "\"";
        }
        return "Basic realm=\"NA\"";
    }

    private static String getTrustedIp() {
        if (ConfigFactory.load().hasPath("trusted.ip")) {
            return ConfigFactory.load().getString("trusted.ip");
        }
        return null;
    }
}

