package actions;

import models.InnoQAccount;
import play.Logger;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Http.Context;
import play.mvc.Result;

import com.ning.http.util.Base64;
import com.typesafe.config.ConfigFactory;

public class InnoQBasicAuthAction extends Action<Object> {

	private final static String AUTHORIZATION = "authorization";
	private final static String REMOTE_USER = "REMOTE_USER";
	private final static String WWW_AUTHENTICATE = "WWW-Authenticate";
	private final static String REALM = getRealm();
	private final static String TRUSTERD_IP = getTrustedIp();

	public F.Promise<Result> call(Http.Context context) throws Throwable {

		String authHeader = context.request().getHeader(AUTHORIZATION);
		String remoteUser = context.request().getHeader(REMOTE_USER);
		String remoteAddress = context.request().remoteAddress();

		if (authHeader == null) {
			return sendAuthRequest(context);
		}
		Logger.info("remote IP is " + remoteAddress + " vs " + TRUSTERD_IP);
		if (remoteAddress.equals(TRUSTERD_IP) && remoteUser != null) {
			InnoQAccount account = InnoQAccount.getOrCreate(remoteUser);
			context.request().setUsername(remoteUser);
			return delegate.call(context);
		} else {
			String auth = authHeader.substring(6);

			byte[] decodedAuth = Base64.decode(auth);
			String[] credString = new String(decodedAuth, "UTF-8").split(":");

			if (credString == null || credString.length != 2) {
				return sendAuthRequest(context);
			}

			String username = credString[0];
			String password = credString[1];
			InnoQAccount authUser = InnoQAccount.authenticate(username, password);
			if (authUser == null) {
				return sendAuthRequest(context);
			}
			context.request().setUsername(username);
			return delegate.call(context);
		}
	}

	private F.Promise<Result> sendAuthRequest(Context context) {
		context.response().setHeader(WWW_AUTHENTICATE, REALM);
		return F.Promise.pure((Result) unauthorized());
	}

	private static String getRealm() {
		if (ConfigFactory.load().hasPath("app.name")) {
			return "Basic realm=\"" + ConfigFactory.load().getString("app.name") + "\"";
		}
		return "Basic realm=\"NA\"";
	}

	private static String getTrustedIp() {
		if (ConfigFactory.load().hasPath("trusted.ip")) {
			return ConfigFactory.load().getString("trusted.ip");
		}
		return null;
	}
}