package models;

import java.util.Set;
import java.util.TreeSet;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

import com.avaje.ebean.Model;
import com.innoq.ldap.connector.LdapGroup;
import com.innoq.ldap.connector.LdapHelper;
import com.innoq.ldap.connector.LdapUser;

@Entity
public class InnoQAccount extends Model {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	public Long id;
	public String uid;

	public String get(String key) {
		return LdapHelper.getInstance().getUser(uid).get(key);
	}

	public Set<String> getKeys() {
		return LdapHelper.getInstance().getUser(uid).getKeys();
	}

	public Set<String> getGroups() {
		Set<String> groups = new TreeSet<String>();
		LdapUser user = (LdapUser) LdapHelper.getInstance().getUser(uid);
		for(LdapGroup group : user.getGroups()) {
			groups.add(group.getCn());
		}
		return groups;
	}
	
	public static Find<Long, InnoQAccount> Finder = new Find<Long, InnoQAccount>() {
	};

	public static InnoQAccount getOrCreate(String uid) {
		InnoQAccount account = InnoQAccount.Finder.where().eq("uid", uid).findUnique();
		if (account == null) {
			account = new InnoQAccount();
			account.uid = uid;
			account.save();
		}
		return account;
	}

	public static InnoQAccount authenticate(String username, String password) {
		LdapHelper helper = LdapHelper.getInstance();
		if (helper.checkCredentials(username.trim(), password.trim())) {
			return InnoQAccount.getOrCreate(username.trim());
		}
		return null;
	}
}
