# innoq-basic-auth

Der Sinn dieses Moduls ist es:

* Einbinden einer Anwendung an das LDAP
* Erstellen eines User-Contextes aus einem `REMOTE_USER` Header.
* Fallback auf LDAP-Auth wenn der `REMOTE_USER` Header nicht vorhanden ist (z.B. für lokale Entwicklung).


## Test-Drive

### Vorbereitung

Die LDAP Library sucht als Standard die Einstellungen in `~/.liqid/liqid.properties`.

Diese Datei sieht ungefähr so aus:

    #LDAP Settings

    ldap.user.objectClasses=top, organizationalPerson, inetOrgPerson, person, posixAccount, shadowAccount,  JabberAccount, ldapPublicKey
    ldap.group.objectClasses=groupOfNames, shadowAccount

    default.ldap=ldap1
    # LDAP Listsing, divided by ","
    ldap.listing=ldap1

    ldap1.base_dn=dc=innoq,dc=com
    ldap1.ou_people=ou=People
    ldap1.ou_group=ou=Group
    ldap1.url=ldaps://testldap.innoq.com:636
    ldap1.principal=##user##
    ldap1.credentials=##pass##

`##user##` kannst Du aus Deinem innoQ Kürzel ableiten. Für `phl` ist das z.B. `uid=phl,ou=People,dc=innoq,dc=com`.
`##pass##` ist Dein Standard innoQ Passwort (die Übertragung findet verschlüsselt statt). Der Test-Server `testldap.innoq.com` enthält nicht alle Benutzer, können durch `christians` oder `phl` eingetragen werden.
Zum Nur-Lesen geht aber auch ein anderer Server, z.B. `ldaps://ldap1.innoq.com:636`.

### Bauen des Modules 
…und Installation ins lokale ivy Repository:

    cd innoq-basic-auth
    activator
    [innoq-basic-auth] $ update
    [innoq-basic-auth] $ publish-local
    …
    [success] Total time: 0 s, completed 13.11.2015 00:25:54

### Starten der Sample Application

    cd samples/innoq-basic-auth-sample
    activator
    [innoq-basic-auth-sample] $ update
    [innoq-basic-auth-sample] $ run
    …
    --- (Running the application, auto-reloading is enabled) ---

    [info] p.c.s.NettyServer - Listening for HTTP on /0:0:0:0:0:0:0:0:9000

    (Server started, use Ctrl+D to stop and go back to the console...)
    
Ein Aufruf von `http://localhost:9000` sollte nun erst eine Basic-Auth Abfrage liefern (da nicht hinter eine Apache). Diese geht direkt gegen die LDAP-Connection und sollte Deine Credentials akzeptieren. Danach wirst Du zur Erstellung der DB aufgerufen. Danach solltest Du eine Liste mit allen User Attributen und Gruppen sehen.
    
    
## Implementierung

Sobald eine Play2-Anwendung das Modul eingebunden hat, lassen sich einzelne Controller (oder Actions) mit:

    @InnoQBasicAuth
    public class Application extends Controller {
    …
    }
    
schützen.


Der Username wird in den Request-Context injected. Es ist also recht einfach hieraus einen User abzuleiten:

    @InnoQBasicAuth
    public class Application extends Controller {

        public Result index() {
    	    InnoQAccount account = InnoQAccount.getOrCreate(request().username());
            return ok(index.render(account));
        }
    }
    
Hier wird das Account Model aus dem Modul verwendet (welches auch Funktionen enthält, um Attribute und Gruppen abzurufen - siehe die View `app/views/index.html.scala`), es ist aber auch möglich ein eigenes Model aus dem Usernamen zu erstellen. Dieser befindet sich in `request().username()`.


## Security

Aus Sicherheitsgründen ist es notwendig, dass die IP des Frontend-Server (der den REMOTE_USER Header injektet) in `conf/application.conf` der jeweiligen Anwendung eingetragen wird:

    …
    # add IP that is allowed to inject REMOTE_USER Header (e.g. Frontend Apache)
    trusted.ip="127.0.0.1"
    …
