/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ParseException;

public class AttachmentInfo {
    private Part part;
    private int num;

    public String getAttachmentType() throws MessagingException {
        String contentType = this.part.getContentType();
        if (contentType == null) {
            return "invalid part";
        }
        return contentType;
    }

    public String getContent() throws IOException, MessagingException {
        if (this.hasMimeType("text/plain")) {
            return (String)this.part.getContent();
        }
        return "";
    }

    public String getDescription() throws MessagingException {
        String description = this.part.getDescription();
        if (description != null) {
            return description;
        }
        return "";
    }

    public String getFilename() throws MessagingException {
        String filename = this.part.getFileName();
        if (filename != null) {
            return filename;
        }
        return "";
    }

    public String getNum() {
        return Integer.toString(this.num);
    }

    public boolean hasDescription() throws MessagingException {
        return this.part.getDescription() != null;
    }

    public boolean hasFilename() throws MessagingException {
        return this.part.getFileName() != null;
    }

    public boolean hasMimeType(String mimeType) throws MessagingException {
        return this.part.isMimeType(mimeType);
    }

    public boolean isInline() throws MessagingException {
        if (this.part.getDisposition() != null) {
            return this.part.getDisposition().equals("inline");
        }
        return true;
    }

    public void setPart(int num, Part part) throws MessagingException, ParseException {
        this.part = part;
        this.num = num;
    }
}

