/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.MailFile;
import com.sun.mail.mbox.UNIXFile;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class UNIXFolder
extends UNIXFile
implements MailFile {
    protected transient RandomAccessFile file;
    private static final long serialVersionUID = -254578891263785591L;

    public UNIXFolder(String name) {
        super(name);
    }

    @Override
    public boolean lock(String mode) {
        try {
            this.file = new RandomAccessFile(this, mode);
            switch (lockType) {
                case 0: {
                    return true;
                }
                default: {
                    return UNIXFile.lock(this.file.getFD(), mode);
                }
                case 2: 
            }
            return this.file.getChannel().tryLock(0L, Long.MAX_VALUE, !mode.equals("rw")) != null;
        }
        catch (FileNotFoundException fe) {
            return false;
        }
        catch (IOException ie) {
            this.file = null;
            return false;
        }
    }

    @Override
    public void unlock() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file = null;
        }
    }

    @Override
    public void touchlock() {
    }

    @Override
    public FileDescriptor getFD() {
        if (this.file == null) {
            return null;
        }
        try {
            return this.file.getFD();
        }
        catch (IOException e) {
            return null;
        }
    }
}

