/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.swing.table.AbstractTableModel;

public class FolderModel
extends AbstractTableModel {
    Folder folder;
    Message[] messages;
    String[] columnNames = new String[]{"Date", "From", "Subject"};
    Class[] columnTypes = new Class[]{String.class, String.class, String.class};
    protected static String[][] cached;

    public void setFolder(Folder what) throws MessagingException {
        if (what != null) {
            if (!what.isOpen()) {
                what.open(2);
            }
            this.messages = what.getMessages();
            cached = new String[this.messages.length][];
        } else {
            this.messages = null;
            cached = null;
        }
        if (this.folder != null) {
            this.folder.close(true);
        }
        this.folder = what;
        this.fireTableDataChanged();
    }

    public Message getMessage(int which) {
        return this.messages[which];
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int column) {
        return this.columnTypes[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.messages == null) {
            return 0;
        }
        return this.messages.length;
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        switch (aColumn) {
            case 0: 
            case 1: 
            case 2: {
                String[] what = this.getCachedData(aRow);
                if (what != null) {
                    return what[aColumn];
                }
                return "";
            }
        }
        return "";
    }

    protected String[] getCachedData(int row) {
        if (cached[row] == null) {
            try {
                Message m = this.messages[row];
                String[] theData = new String[4];
                Date date = m.getSentDate();
                theData[0] = date == null ? "Unknown" : date.toString();
                Address[] adds = m.getFrom();
                theData[1] = adds != null && adds.length != 0 ? adds[0].toString() : "";
                String subject = m.getSubject();
                theData[2] = subject != null ? subject : "(No Subject)";
                FolderModel.cached[row] = theData;
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
        return cached[row];
    }
}

