/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Date;
import javax.activation.CommandInfo;
import javax.activation.CommandObject;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.swing.JPanel;

public class MessageViewer
extends JPanel
implements CommandObject {
    Message displayed = null;
    DataHandler dataHandler = null;
    String verb = null;
    Component mainbody;
    TextArea headers;

    public MessageViewer() {
        this((Message)null);
    }

    public MessageViewer(Message what) {
        super(new GridBagLayout());
        this.addToolbar();
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridwidth = 0;
        gb.fill = 1;
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        this.headers = new TextArea("", 4, 80, 3);
        this.headers.setEditable(false);
        this.add((Component)this.headers, gb);
        this.setMessage(what);
    }

    public void setMessage(Message what) {
        this.displayed = what;
        if (this.mainbody != null) {
            this.remove(this.mainbody);
        }
        if (what != null) {
            this.loadHeaders();
            this.mainbody = this.getBodyComponent();
        } else {
            this.headers.setText("");
            TextArea dummy = new TextArea("", 24, 80, 3);
            dummy.setEditable(false);
            this.mainbody = dummy;
        }
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridwidth = 0;
        gb.fill = 1;
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        this.add(this.mainbody, gb);
        this.invalidate();
        this.validate();
    }

    protected void addToolbar() {
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridheight = 1;
        gb.gridwidth = 1;
        gb.fill = 0;
        gb.anchor = 17;
        gb.weightx = 0.0;
        gb.weighty = 0.0;
        gb.insets = new Insets(4, 4, 4, 4);
        gb.gridwidth = 0;
        Button b = new Button("Structure");
        b.addActionListener(new StructureAction());
        this.add((Component)b, gb);
    }

    protected void loadHeaders() {
        StringBuffer sb = new StringBuffer();
        sb.append("Date: ");
        try {
            Date duh = this.displayed.getSentDate();
            if (duh != null) {
                sb.append(duh.toString());
            } else {
                sb.append("Unknown");
            }
            sb.append("\n");
            sb.append("From: ");
            Address[] adds = this.displayed.getFrom();
            if (adds != null && adds.length > 0) {
                sb.append(adds[0].toString());
            }
            sb.append("\n");
            sb.append("To: ");
            adds = this.displayed.getRecipients(Message.RecipientType.TO);
            if (adds != null && adds.length > 0) {
                sb.append(adds[0].toString());
            }
            sb.append("\n");
            sb.append("Subject: ");
            sb.append(this.displayed.getSubject());
            this.headers.setText(sb.toString());
        }
        catch (MessagingException me) {
            this.headers.setText("");
        }
    }

    protected Component getBodyComponent() {
        try {
            DataHandler dh = this.displayed.getDataHandler();
            CommandInfo ci = dh.getCommand("view");
            if (ci == null) {
                throw new MessagingException("view command failed on: " + this.displayed.getContentType());
            }
            Object bean = dh.getBean(ci);
            if (bean instanceof Component) {
                return (Component)bean;
            }
            throw new MessagingException("bean is not a component " + bean.getClass().toString());
        }
        catch (MessagingException me) {
            return new Label(me.toString());
        }
    }

    public void setCommandContext(String verb, DataHandler dh) throws IOException {
        this.verb = verb;
        this.dataHandler = dh;
        Object o = dh.getContent();
        if (o instanceof Message) {
            this.setMessage((Message)o);
        } else {
            System.out.println("MessageViewer - content not a Message object, " + o);
            if (o != null) {
                System.out.println(o.getClass().toString());
            }
        }
    }

    class StructureAction
    implements ActionListener {
        StringBuffer sb;

        StructureAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("\n\nMessage Structure");
            this.dumpPart("", (Part)MessageViewer.this.displayed);
        }

        protected void dumpPart(String prefix, Part p) {
            try {
                System.out.println(prefix + "----------------");
                System.out.println(prefix + "Content-Type: " + p.getContentType());
                System.out.println(prefix + "Class: " + p.getClass().toString());
                Object o = p.getContent();
                if (o == null) {
                    System.out.println(prefix + "Content:  is null");
                } else {
                    System.out.println(prefix + "Content: " + o.getClass().toString());
                }
                if (o instanceof Multipart) {
                    String newpref = prefix + "\t";
                    Multipart mp = (Multipart)o;
                    int count = mp.getCount();
                    for (int i = 0; i < count; ++i) {
                        this.dumpPart(newpref, (Part)mp.getBodyPart(i));
                    }
                }
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
            catch (IOException ioex) {
                System.out.println("Cannot get content" + ioex.getMessage());
            }
        }
    }
}

