/*
 * Decompiled with CFR 0.152.
 */
import com.sun.mail.imap.IMAPFolder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;

public class monitor {
    public static void main(String[] argv) {
        if (argv.length != 5) {
            System.out.println("Usage: monitor <host> <user> <password> <mbox> <freq>");
            System.exit(1);
        }
        System.out.println("\nTesting monitor\n");
        try {
            IMAPFolder f;
            Properties props = System.getProperties();
            Session session = Session.getInstance((Properties)props, null);
            Store store = session.getStore("imap");
            store.connect(argv[0], argv[1], argv[2]);
            Folder folder = store.getFolder(argv[3]);
            if (folder == null || !folder.exists()) {
                System.out.println("Invalid folder");
                System.exit(1);
            }
            folder.open(2);
            folder.addMessageCountListener((MessageCountListener)new MessageCountAdapter(){

                public void messagesAdded(MessageCountEvent ev) {
                    Message[] msgs = ev.getMessages();
                    System.out.println("Got " + msgs.length + " new messages");
                    for (int i = 0; i < msgs.length; ++i) {
                        try {
                            System.out.println("-----");
                            System.out.println("Message " + msgs[i].getMessageNumber() + ":");
                            msgs[i].writeTo((OutputStream)System.out);
                            continue;
                        }
                        catch (IOException ioex) {
                            ioex.printStackTrace();
                            continue;
                        }
                        catch (MessagingException mex) {
                            mex.printStackTrace();
                        }
                    }
                }
            });
            int freq = Integer.parseInt(argv[4]);
            boolean supportsIdle = false;
            try {
                if (folder instanceof IMAPFolder) {
                    f = (IMAPFolder)folder;
                    f.idle();
                    supportsIdle = true;
                }
            }
            catch (FolderClosedException fex) {
                throw fex;
            }
            catch (MessagingException mex) {
                supportsIdle = false;
            }
            while (true) {
                if (supportsIdle && folder instanceof IMAPFolder) {
                    f = (IMAPFolder)folder;
                    f.idle();
                    System.out.println("IDLE done");
                    continue;
                }
                Thread.sleep(freq);
                folder.getMessageCount();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }
}

