/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class msgsendsample {
    static String msgText = "This is a message body.\nHere's the second line.";

    public static void main(String[] args) {
        if (args.length != 4) {
            msgsendsample.usage();
            System.exit(1);
        }
        System.out.println();
        String to = args[0];
        String from = args[1];
        String host = args[2];
        boolean debug = Boolean.valueOf(args[3]);
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        if (debug) {
            props.put("mail.debug", args[3]);
        }
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(debug);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject("JavaMail APIs Test");
            msg.setSentDate(new Date());
            msg.setText(msgText);
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            System.out.println("\n--Exception handling in msgsendsample.java");
            mex.printStackTrace();
            System.out.println();
            Throwable ex = mex;
            do {
                if (ex instanceof SendFailedException) {
                    Address[] validSent;
                    Address[] validUnsent;
                    SendFailedException sfex = (SendFailedException)ex;
                    Address[] invalid = sfex.getInvalidAddresses();
                    if (invalid != null) {
                        System.out.println("    ** Invalid Addresses");
                        for (int i = 0; i < invalid.length; ++i) {
                            System.out.println("         " + invalid[i]);
                        }
                    }
                    if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                        System.out.println("    ** ValidUnsent Addresses");
                        for (int i = 0; i < validUnsent.length; ++i) {
                            System.out.println("         " + validUnsent[i]);
                        }
                    }
                    if ((validSent = sfex.getValidSentAddresses()) != null) {
                        System.out.println("    ** ValidSent Addresses");
                        for (int i = 0; i < validSent.length; ++i) {
                            System.out.println("         " + validSent[i]);
                        }
                    }
                }
                System.out.println();
            } while ((ex = ex instanceof MessagingException ? ex.getNextException() : null) != null);
        }
    }

    private static void usage() {
        System.out.println("usage: java msgsendsample <to> <from> <smtp> true|false");
    }
}

