/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.activation.FileTypeMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

public class MSBodyPart
extends MimeBodyPart {
    private int start;
    private int end;
    private String type = "UNKNOWN";
    private String disposition;
    private String encoding;
    private String filename = "UNKNOWN";
    private static final String UNKNOWN = "UNKNOWN";

    public MSBodyPart(byte[] content, int start, int end, String disposition, String encoding) {
        this.content = content;
        this.start = start;
        this.end = end;
        this.disposition = disposition;
        this.encoding = encoding;
    }

    public String getContentType() throws MessagingException {
        if (this.type == UNKNOWN) {
            this.processBegin();
        }
        return this.type;
    }

    public String getEncoding() throws MessagingException {
        return this.encoding;
    }

    public String getDisposition() throws MessagingException {
        return this.disposition;
    }

    public String getFileName() throws MessagingException {
        if (this.filename == UNKNOWN) {
            this.processBegin();
        }
        return this.filename;
    }

    protected InputStream getContentStream() {
        return new ByteArrayInputStream(this.content, this.start, this.end - this.start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBegin() {
        InputStream in = this.getContentStream();
        try {
            int i;
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            String begin = r.readLine();
            if (begin != null && begin.regionMatches(true, 0, "begin ", 0, 6) && (i = begin.indexOf(32, 6)) > 0) {
                this.filename = begin.substring(i + 1);
                FileTypeMap map = FileTypeMap.getDefaultFileTypeMap();
                this.type = map.getContentType(this.filename);
                if (this.type == null) {
                    this.type = "application/octet-stream";
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            if (this.filename == UNKNOWN) {
                this.filename = null;
            }
            if (this.type == UNKNOWN || this.type == null) {
                this.type = "text/plain";
            }
        }
    }
}

