/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public class MSMessage
extends MimeMessage {
    private String type;

    public MSMessage(Session session, MimeMessage msg) throws MessagingException {
        super(session);
        if (!MSMessage.isMSMessage(msg)) {
            throw new MessagingException("Not an MS message");
        }
        class FastByteArrayOutputStream
        extends ByteArrayOutputStream {
            FastByteArrayOutputStream() {
            }

            ByteArrayInputStream toByteArrayInputStream() {
                return new ByteArrayInputStream(this.buf, 0, this.count);
            }
        }
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        try {
            msg.writeTo((OutputStream)bos);
        }
        catch (IOException ioex) {
            throw new MessagingException("IOException", (Exception)ioex);
        }
        catch (Exception ex) {
            throw new MessagingException("Exception", ex);
        }
        this.parse(bos.toByteArrayInputStream());
    }

    public MSMessage(Session session, InputStream is) throws MessagingException {
        super(session);
        this.parse(is);
    }

    protected void parse(InputStream is) throws MessagingException {
        if (!(is instanceof ByteArrayInputStream) && !(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        this.headers.load(is);
        try {
            int b;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((b = is.read()) != -1) {
                bos.write(b);
            }
            this.content = bos.toByteArray();
        }
        catch (IOException ioex) {
            throw new MessagingException("IOException", (Exception)ioex);
        }
        boolean isMulti = false;
        String[] att = this.getHeader("X-MS-Attachment");
        if (att != null && att.length > 0) {
            isMulti = true;
        } else {
            for (int i = 0; i < this.content.length; ++i) {
                String s;
                int b = this.content[i] & 0xFF;
                if (b != 13 && b != 10 || i + 5 >= this.content.length || !(s = MSMessage.toString(this.content, i + 1, i + 6)).equalsIgnoreCase("begin")) continue;
                isMulti = true;
                break;
            }
        }
        if (isMulti) {
            this.type = "multipart/mixed";
            this.dh = new DataHandler((DataSource)new MSMultipartDataSource((MimePart)this, this.content));
        } else {
            this.type = "text/plain";
            this.dh = new DataHandler((DataSource)new MimePartDataSource((MimePart)this));
        }
        this.modified = false;
    }

    public String getContentType() throws MessagingException {
        return this.type;
    }

    public String getDisposition() throws MessagingException {
        return "inline";
    }

    public String getEncoding() throws MessagingException {
        return "7bit";
    }

    public static boolean isMSMessage(MimeMessage msg) throws MessagingException {
        if (msg.getHeader("MIME-Version") != null) {
            return false;
        }
        String[] att = msg.getHeader("X-MS-Attachment");
        return att != null && att.length != 0;
    }

    static String toString(byte[] b, int start, int end) {
        int size = end - start;
        char[] theChars = new char[size];
        int i = 0;
        int j = start;
        while (i < size) {
            theChars[i++] = (char)b[j++];
        }
        return new String(theChars);
    }
}

