/*
 * Decompiled with CFR 0.152.
 */
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.swing.tree.DefaultMutableTreeNode;

public class FolderTreeNode
extends DefaultMutableTreeNode {
    protected Folder folder = null;
    protected boolean hasLoaded = false;

    public FolderTreeNode(Folder what) {
        super(what);
        this.folder = what;
    }

    @Override
    public boolean isLeaf() {
        try {
            if ((this.folder.getType() & 2) == 0) {
                return true;
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return false;
    }

    public Folder getFolder() {
        return this.folder;
    }

    @Override
    public int getChildCount() {
        if (!this.hasLoaded) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    protected void loadChildren() {
        if (this.isLeaf()) {
            this.hasLoaded = true;
            return;
        }
        try {
            Folder[] sub = this.folder.list();
            int num = sub.length;
            for (int i = 0; i < num; ++i) {
                FolderTreeNode node = new FolderTreeNode(sub[i]);
                this.insert(node, i);
            }
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return this.folder.getName();
    }
}

