/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.activation.CommandInfo;
import javax.activation.CommandObject;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.swing.JPanel;

public class MultipartViewer
extends JPanel
implements CommandObject {
    protected DataHandler dh = null;
    protected String verb = null;

    public MultipartViewer() {
        super(new GridBagLayout());
    }

    public void setCommandContext(String verb, DataHandler dh) throws IOException {
        this.verb = verb;
        this.dh = dh;
        Object content = dh.getContent();
        if (content instanceof Multipart) {
            this.setupDisplay((Multipart)content);
        } else {
            this.setupErrorDisplay(content);
        }
    }

    protected void setupDisplay(Multipart mp) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridheight = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        try {
            BodyPart bp = mp.getBodyPart(0);
            Component comp = this.getComponent(bp);
            this.add(comp, gc);
        }
        catch (MessagingException me) {
            this.add((Component)new Label(me.toString()), gc);
        }
        try {
            int count = mp.getCount();
            gc.gridwidth = 0;
            gc.gridheight = 1;
            gc.fill = 0;
            gc.anchor = 11;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(4, 4, 4, 4);
            for (int i = 1; i < count; ++i) {
                BodyPart curr = mp.getBodyPart(i);
                String label = null;
                if (label == null) {
                    label = curr.getFileName();
                }
                if (label == null) {
                    label = curr.getDescription();
                }
                if (label == null) {
                    label = curr.getContentType();
                }
                Button but = new Button(label);
                but.addActionListener(new AttachmentViewer(curr));
                this.add((Component)but, gc);
            }
        }
        catch (MessagingException me2) {
            me2.printStackTrace();
        }
    }

    protected Component getComponent(BodyPart bp) {
        try {
            DataHandler dh = bp.getDataHandler();
            CommandInfo ci = dh.getCommand("view");
            if (ci == null) {
                throw new MessagingException("view command failed on: " + bp.getContentType());
            }
            Object bean = dh.getBean(ci);
            if (bean instanceof Component) {
                return (Component)bean;
            }
            if (bean == null) {
                throw new MessagingException("bean is null, class " + ci.getCommandClass() + " , command " + ci.getCommandName());
            }
            throw new MessagingException("bean is not a awt.Component" + bean.getClass().toString());
        }
        catch (MessagingException me) {
            return new Label(me.toString());
        }
    }

    protected void setupErrorDisplay(Object content) {
        String error = content == null ? "Content is null" : "Object not of type Multipart, content class = " + content.getClass().toString();
        System.out.println(error);
        Label lab = new Label(error);
        this.add(lab);
    }

    class AttachmentViewer
    implements ActionListener {
        BodyPart bp = null;

        public AttachmentViewer(BodyPart part) {
            this.bp = part;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentFrame f = new ComponentFrame(MultipartViewer.this.getComponent(this.bp), "Attachment");
            f.pack();
            f.show();
        }
    }
}

