/*
 * Decompiled with CFR 0.152.
 */
import com.sun.mail.util.logging.CollectorFormatter;
import com.sun.mail.util.logging.DurationFilter;
import com.sun.mail.util.logging.MailHandler;
import com.sun.mail.util.logging.SeverityComparator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;

public class MailHandlerDemo {
    private static final String CLASS_NAME = MailHandlerDemo.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private static Handler pushOnlyHandler;
    private static Handler pushNormalHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        List<String> l = Arrays.asList(args);
        if (l.contains("/?") || l.contains("-?") || l.contains("-help")) {
            LOGGER.info("Usage: java MailHandlerDemo [[-all] | [-body] | [-custom] | [-debug] | [-low] | [-simple] | [-pushlevel] | [-pushfilter] | [-pushnormal] | [-pushonly]] \n\n-all\t\t: Execute all demos.\n-body\t\t: An email with all records and only a body.\n-custom\t\t: An email with attachments and dynamic names.\n-debug\t\t: Output basic debug information about the JVM and log configuration.\n-low\t\t: Generates multiple emails due to low capacity.\n-simple\t\t: An email with all records with body and an attachment.\n-pushlevel\t: Generates high priority emails when the push level is triggered and normal priority when flushed.\n-pushFilter\t: Generates high priority emails when the push level and the push filter is triggered and normal priority emails when flushed.\n-pushnormal\t: Generates multiple emails when the MemoryHandler push level is triggered.  All generated email are sent as normal priority.\n-pushonly\t: Generates multiple emails when the MemoryHandler push level is triggered.  Generates high priority emails when the push level is triggered and normal priority when flushed.\n");
        } else {
            boolean debug = MailHandlerDemo.init(l);
            try {
                LOGGER.log(Level.FINEST, "This is the finest part of the demo.", (Throwable)new MessagingException("Fake JavaMail issue."));
                LOGGER.log(Level.FINER, "This is the finer part of the demo.", new NullPointerException("Fake bug."));
                LOGGER.log(Level.FINE, "This is the fine part of the demo.");
                LOGGER.log(Level.CONFIG, "Logging config file is {0}.", MailHandlerDemo.getConfigLocation());
                LOGGER.log(Level.INFO, "Your temp directory is {0}, please wait...", MailHandlerDemo.getTempDir());
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                LOGGER.log(Level.WARNING, "This is a warning.", new FileNotFoundException("Fake file chooser issue."));
                LOGGER.log(Level.SEVERE, "The end of the demo.", new IOException("Fake access denied issue."));
            }
            finally {
                MailHandlerDemo.closeHandlers();
            }
            if (debug && MailHandlerDemo.getConfigLocation() != null) {
                LogManager.getLogManager().readConfiguration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkConfig(String prefix, PrintStream err) {
        if (prefix == null || prefix.trim().length() == 0) {
            prefix = "DEBUG";
        }
        if (err == null) {
            err = System.out;
        }
        try {
            String from;
            err.println(prefix + ": java.version=" + System.getProperty("java.version"));
            err.println(prefix + ": LOGGER=" + LOGGER.getLevel());
            err.println(prefix + ": JVM id " + ManagementFactory.getRuntimeMXBean().getName());
            err.println(prefix + ": java.security.debug=" + System.getProperty("java.security.debug"));
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                err.println(prefix + ": SecurityManager.class=" + sm.getClass().getName());
                err.println(prefix + ": SecurityManager classLoader=" + MailHandlerDemo.toString(sm.getClass().getClassLoader()));
                err.println(prefix + ": SecurityManager.toString=" + sm);
            } else {
                err.println(prefix + ": SecurityManager.class=null");
                err.println(prefix + ": SecurityManager.toString=null");
                err.println(prefix + ": SecurityManager classLoader=null");
            }
            String policy = System.getProperty("java.security.policy");
            if (policy != null) {
                File f = new File(policy);
                err.println(prefix + ": AbsolutePath=" + f.getAbsolutePath());
                err.println(prefix + ": CanonicalPath=" + f.getCanonicalPath());
                err.println(prefix + ": length=" + f.length());
                err.println(prefix + ": canRead=" + f.canRead());
                err.println(prefix + ": lastModified=" + new Date(f.lastModified()));
            }
            LogManager manager = LogManager.getLogManager();
            String key = "java.util.logging.config.file";
            String cfg = System.getProperty(key);
            if (cfg != null) {
                err.println(prefix + ": " + cfg);
                File f = new File(cfg);
                err.println(prefix + ": AbsolutePath=" + f.getAbsolutePath());
                err.println(prefix + ": CanonicalPath=" + f.getCanonicalPath());
                err.println(prefix + ": length=" + f.length());
                err.println(prefix + ": canRead=" + f.canRead());
                err.println(prefix + ": lastModified=" + new Date(f.lastModified()));
            } else {
                err.println(prefix + ": " + key + " is not set as a system property.");
            }
            err.println(prefix + ": LogManager.class=" + manager.getClass().getName());
            err.println(prefix + ": LogManager classLoader=" + MailHandlerDemo.toString(manager.getClass().getClassLoader()));
            err.println(prefix + ": LogManager.toString=" + manager);
            err.println(prefix + ": MailHandler classLoader=" + MailHandlerDemo.toString(MailHandler.class.getClassLoader()));
            err.println(prefix + ": Context ClassLoader=" + MailHandlerDemo.toString(Thread.currentThread().getContextClassLoader()));
            err.println(prefix + ": Session ClassLoader=" + MailHandlerDemo.toString(Session.class.getClassLoader()));
            err.println(prefix + ": DataHandler ClassLoader=" + MailHandlerDemo.toString(DataHandler.class.getClassLoader()));
            String p = MailHandler.class.getName();
            key = p.concat(".mail.to");
            String to = manager.getProperty(key);
            err.println(prefix + ": TO=" + to);
            if (to != null) {
                err.println(prefix + ": TO=" + Arrays.toString(InternetAddress.parse((String)to, (boolean)true)));
            }
            if ((from = manager.getProperty(key = p.concat(".mail.from"))) == null || from.length() == 0) {
                Session session = Session.getInstance((Properties)new Properties());
                InternetAddress local = InternetAddress.getLocalAddress((Session)session);
                err.println(prefix + ": FROM=" + local);
            } else {
                err.println(prefix + ": FROM=" + Arrays.asList(InternetAddress.parse((String)from, (boolean)false)));
                err.println(prefix + ": FROM=" + Arrays.asList(InternetAddress.parse((String)from, (boolean)true)));
            }
            LogManager logManager = manager;
            synchronized (logManager) {
                Enumeration<String> e = manager.getLoggerNames();
                while (e.hasMoreElements()) {
                    Handler[] handlers;
                    Logger l = manager.getLogger(e.nextElement());
                    if (l == null || (handlers = l.getHandlers()).length <= 0) continue;
                    err.println(prefix + ": " + l.getClass().getName() + ", " + l.getName());
                    for (Handler h : handlers) {
                        err.println(prefix + ":\t" + MailHandlerDemo.toString(prefix, err, h));
                    }
                }
            }
        }
        catch (Throwable error) {
            err.print(prefix + ": ");
            error.printStackTrace(err);
        }
        err.flush();
    }

    private static String toString(ClassLoader cl) {
        StringBuilder buf = new StringBuilder();
        buf.append(cl);
        while (cl != null) {
            cl = cl.getParent();
            buf.append("<-").append(cl);
        }
        return buf.toString();
    }

    private static String toString(String prefix, PrintStream err, Handler h) {
        MailHandler mh;
        StringBuilder buf = new StringBuilder();
        buf.append(h.getClass().getName());
        try {
            if (h instanceof MailHandler) {
                mh = (MailHandler)h;
                buf.append(", ").append(mh.getSubject());
            }
        }
        catch (SecurityException error) {
            err.print(prefix + ": ");
            error.printStackTrace(err);
        }
        try {
            buf.append(", ").append(h.getFormatter());
        }
        catch (SecurityException error) {
            err.print(prefix + ": ");
            error.printStackTrace(err);
        }
        try {
            if (h instanceof MailHandler) {
                mh = (MailHandler)h;
                buf.append(", ").append(Arrays.toString(mh.getAttachmentFormatters()));
            }
        }
        catch (SecurityException error) {
            err.print(prefix + ": ");
            error.printStackTrace(err);
        }
        try {
            buf.append(", ").append(h.getLevel());
        }
        catch (SecurityException error) {
            err.print(prefix + ": ");
            error.printStackTrace(err);
        }
        try {
            buf.append(", ").append(h.getFilter());
        }
        catch (SecurityException error) {
            err.print(prefix + ": ");
            error.printStackTrace(err);
        }
        try {
            buf.append(", ").append(h.getErrorManager());
        }
        catch (SecurityException error) {
            err.print(prefix + ": ");
            error.printStackTrace(err);
        }
        buf.append(", ").append(MailHandlerDemo.toString(h.getClass().getClassLoader()));
        return buf.toString();
    }

    private static void initBodyOnly() {
        MailHandler h = new MailHandler();
        h.setSubject("Body only demo");
        LOGGER.addHandler((Handler)h);
    }

    private static void initLowCapacity() {
        MailHandler h = new MailHandler(5);
        h.setSubject("Low capacity demo");
        LOGGER.addHandler((Handler)h);
    }

    private static void initSimpleAttachment() {
        MailHandler h = new MailHandler();
        h.setSubject("Body and attachment demo");
        h.setAttachmentFormatters(new Formatter[]{new XMLFormatter()});
        h.setAttachmentNames(new String[]{"data.xml"});
        LOGGER.addHandler((Handler)h);
    }

    private static void initWithPushLevel() {
        MailHandler h = new MailHandler();
        h.setSubject("Push level demo");
        h.setPushLevel(Level.WARNING);
        LOGGER.addHandler((Handler)h);
    }

    private static void initWithPushFilter() {
        MailHandler h = new MailHandler();
        h.setSubject("Push filter demo");
        h.setPushLevel(Level.ALL);
        h.setPushFilter((Filter)new DurationFilter(2L, 60000L));
        LOGGER.addHandler((Handler)h);
    }

    private static void initPushOnly() {
        int capacity = 3;
        Level pushLevel = Level.WARNING;
        MailHandler h = new MailHandler(3);
        h.setPushLevel(pushLevel);
        h.setSubject("Push only demo");
        MemoryHandler m = new MemoryHandler((Handler)h, 3, pushLevel);
        h.setLevel(m.getLevel());
        LOGGER.addHandler(m);
        pushOnlyHandler = h;
    }

    private static void initPushNormal() {
        int capacity = 3;
        MailHandler h = new MailHandler(3);
        h.setSubject("Push normal demo");
        MemoryHandler m = new MemoryHandler((Handler)h, 3, Level.WARNING){

            @Override
            public void push() {
                super.push();
                super.flush();
            }
        };
        LOGGER.addHandler(m);
        pushNormalHandler = h;
    }

    private static void initCustomAttachments() {
        MailHandler h = new MailHandler();
        h.setComparator(Collections.reverseOrder(new SeverityComparator()));
        h.setSubject((Formatter)new CollectorFormatter());
        h.setFormatter((Formatter)new SummaryFormatter());
        h.setAttachmentFormatters(new Formatter[]{new XMLFormatter(), new XMLFormatter(), new SimpleFormatter()});
        h.setAttachmentFilters(new Filter[]{null, new DurationFilter(3L, 1000L), new DurationFilter(1L, 900000L)});
        h.setAttachmentNames(new Formatter[]{new CollectorFormatter("all.xml"), new CollectorFormatter("{3} records and {5} errors.xml"), new CollectorFormatter("{5,choice,0#no errors|1#1 error|1<{5,number,integer} errors}.txt")});
        LOGGER.addHandler((Handler)h);
    }

    private static boolean init(List<String> l) {
        boolean debug;
        boolean all;
        l = new ArrayList<String>(l);
        Session session = Session.getInstance((Properties)System.getProperties());
        boolean bl = all = l.remove("-all") || l.isEmpty();
        if (l.remove("-body") || all) {
            MailHandlerDemo.initBodyOnly();
        }
        if (l.remove("-custom") || all) {
            MailHandlerDemo.initCustomAttachments();
        }
        if (l.remove("-low") || all) {
            MailHandlerDemo.initLowCapacity();
        }
        if (l.remove("-pushfilter") || all) {
            MailHandlerDemo.initWithPushFilter();
        }
        if (l.remove("-pushlevel") || all) {
            MailHandlerDemo.initWithPushLevel();
        }
        if (l.remove("-pushnormal") || all) {
            MailHandlerDemo.initPushNormal();
        }
        if (l.remove("-pushonly") || all) {
            MailHandlerDemo.initPushOnly();
        }
        if (l.remove("-simple") || all) {
            MailHandlerDemo.initSimpleAttachment();
        }
        boolean fallback = MailHandlerDemo.applyFallbackSettings();
        boolean bl2 = debug = l.remove("-debug") || session.getDebug();
        if (debug) {
            MailHandlerDemo.checkConfig(CLASS_NAME, session.getDebugOut());
        }
        if (!l.isEmpty()) {
            LOGGER.log(Level.SEVERE, "Unknown commands: {0}", l);
        }
        if (fallback) {
            LOGGER.info("Check your user temp dir for output.");
        }
        return debug;
    }

    private static void closeHandlers() {
        Handler[] handlers;
        for (Handler h : handlers = LOGGER.getHandlers()) {
            h.close();
            LOGGER.removeHandler(h);
        }
    }

    private static boolean applyFallbackSettings() {
        if (MailHandlerDemo.getConfigLocation() == null) {
            Handler[] handlers;
            LOGGER.setLevel(Level.ALL);
            for (Handler h : handlers = LOGGER.getHandlers()) {
                MailHandlerDemo.fallbackSettings(h);
            }
            MailHandlerDemo.fallbackSettings(pushOnlyHandler);
            MailHandlerDemo.fallbackSettings(pushNormalHandler);
            return true;
        }
        return false;
    }

    private static void fallbackSettings(Handler h) {
        if (h != null) {
            h.setErrorManager(new FileErrorManager());
            h.setLevel(Level.ALL);
        }
    }

    private static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    private static String getConfigLocation() {
        String file = System.getProperty("java.util.logging.config.file");
        if (file == null) {
            return System.getProperty("java.util.logging.config.class");
        }
        return file;
    }

    private MailHandlerDemo() throws IllegalAccessException {
        throw new IllegalAccessException();
    }
}

