/*
 * Decompiled with CFR 0.152.
 */
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class NewlineOutputStream
extends FilterOutputStream {
    private int lastb = -1;
    private static byte[] newline;

    public NewlineOutputStream(OutputStream os) {
        super(os);
        if (newline == null) {
            String s = System.getProperty("line.separator");
            if (s == null || s.length() <= 0) {
                s = "\n";
            }
            try {
                newline = s.getBytes("iso-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                newline = new byte[]{10};
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13) {
            this.out.write(newline);
        } else if (b == 10) {
            if (this.lastb != 13) {
                this.out.write(newline);
            }
        } else {
            this.out.write(b);
        }
        this.lastb = b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }
}

